/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.lucenelegacy.sort;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public final class TermOrdValComparator
extends FieldComparator<BytesRef>
implements LeafFieldComparator {
    private int[] ords;
    private BytesRef[] values;
    private BytesRefBuilder[] tempBRs;
    private int[] readerGen;
    int currentReaderGen = -1;
    SortedDocValues termsIndex;
    private final String field;
    int bottomSlot = -1;
    int bottomOrd;
    boolean bottomSameReader;
    BytesRef bottomValue;
    BytesRef topValue;
    boolean topSameReader;
    int topOrd;
    final int missingSortCmp;
    final int missingOrd;
    private final int numHits;

    public TermOrdValComparator(int numHits, String field) {
        this(numHits, field, false);
    }

    public TermOrdValComparator(int numHits, String field, boolean sortMissingLast) {
        this.numHits = numHits;
        int initialSize = Math.min(1024, numHits);
        this.ords = new int[initialSize];
        this.values = new BytesRef[initialSize];
        this.tempBRs = new BytesRefBuilder[initialSize];
        this.readerGen = new int[initialSize];
        this.field = field;
        if (sortMissingLast) {
            this.missingSortCmp = 1;
            this.missingOrd = Integer.MAX_VALUE;
        } else {
            this.missingSortCmp = -1;
            this.missingOrd = -1;
        }
    }

    private int getOrdForDoc(int doc) throws IOException {
        if (this.termsIndex.advanceExact(doc)) {
            return this.termsIndex.ordValue();
        }
        return -1;
    }

    public int compare(int slot1, int slot2) {
        if (this.readerGen[slot1] == this.readerGen[slot2]) {
            return this.ords[slot1] - this.ords[slot2];
        }
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return this.missingSortCmp;
        }
        if (val2 == null) {
            return -this.missingSortCmp;
        }
        return val1.compareTo(val2);
    }

    public int compareBottom(int doc) throws IOException {
        assert (this.bottomSlot != -1);
        int docOrd = this.getOrdForDoc(doc);
        if (docOrd == -1) {
            docOrd = this.missingOrd;
        }
        if (this.bottomSameReader) {
            return this.bottomOrd - docOrd;
        }
        if (this.bottomOrd >= docOrd) {
            return 1;
        }
        return -1;
    }

    private void ensureCapacity(int slot) {
        if (this.values.length <= slot) {
            int newSize = Math.min(this.numHits, slot * 2);
            this.values = Arrays.copyOf(this.values, newSize);
            this.tempBRs = Arrays.copyOf(this.tempBRs, newSize);
            this.ords = Arrays.copyOf(this.ords, newSize);
            this.readerGen = Arrays.copyOf(this.readerGen, newSize);
        }
    }

    public void copy(int slot, int doc) throws IOException {
        this.ensureCapacity(slot);
        int ord = this.getOrdForDoc(doc);
        if (ord == -1) {
            ord = this.missingOrd;
            this.values[slot] = null;
        } else {
            assert (ord >= 0);
            if (this.tempBRs[slot] == null) {
                this.tempBRs[slot] = new BytesRefBuilder();
            }
            this.tempBRs[slot].copyBytes(this.termsIndex.lookupOrd(ord));
            this.values[slot] = this.tempBRs[slot].get();
        }
        this.ords[slot] = ord;
        this.readerGen[slot] = this.currentReaderGen;
    }

    protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
        return DocValues.getSorted((LeafReader)context.reader(), (String)field);
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        this.termsIndex = this.getSortedDocValues(context, this.field);
        ++this.currentReaderGen;
        if (this.topValue != null) {
            int ord = this.termsIndex.lookupTerm(this.topValue);
            if (ord >= 0) {
                this.topSameReader = true;
                this.topOrd = ord;
            } else {
                this.topSameReader = false;
                this.topOrd = -ord - 2;
            }
        } else {
            this.topOrd = this.missingOrd;
            this.topSameReader = true;
        }
        if (this.bottomSlot != -1) {
            this.setBottom(this.bottomSlot);
        }
        return this;
    }

    public void setBottom(int bottom) throws IOException {
        this.bottomSlot = bottom;
        this.bottomValue = this.values[this.bottomSlot];
        if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
            this.bottomOrd = this.ords[this.bottomSlot];
            this.bottomSameReader = true;
        } else if (this.bottomValue == null) {
            assert (this.ords[this.bottomSlot] == this.missingOrd);
            this.bottomOrd = this.missingOrd;
            this.bottomSameReader = true;
            this.readerGen[this.bottomSlot] = this.currentReaderGen;
        } else {
            int ord = this.termsIndex.lookupTerm(this.bottomValue);
            if (ord < 0) {
                this.bottomOrd = -ord - 2;
                this.bottomSameReader = false;
            } else {
                this.bottomOrd = ord;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
                this.ords[this.bottomSlot] = this.bottomOrd;
            }
        }
    }

    public void setTopValue(BytesRef value) {
        this.topValue = value;
    }

    public BytesRef value(int slot) {
        return this.values[slot];
    }

    public int compareTop(int doc) throws IOException {
        int ord = this.getOrdForDoc(doc);
        if (ord == -1) {
            ord = this.missingOrd;
        }
        if (this.topSameReader) {
            return this.topOrd - ord;
        }
        if (ord <= this.topOrd) {
            return 1;
        }
        return -1;
    }

    public int compareValues(BytesRef val1, BytesRef val2) {
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return this.missingSortCmp;
        }
        if (val2 == null) {
            return -this.missingSortCmp;
        }
        return val1.compareTo(val2);
    }

    public void setScorer(Scorer scorer) {
    }
}

