/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractProductHandlerMojo;
import com.atlassian.maven.plugins.amps.MavenContext;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.PdkParams;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.util.ClassUtils;
import com.atlassian.maven.plugins.amps.util.WiredTestInfo;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.BasicAuthSecurityHandler;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.httpclient.ApacheHttpClientConfig;
import org.apache.wink.common.http.HttpStatus;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="remote-test", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RemoteTestMojo
extends AbstractProductHandlerMojo {
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="functional.test.pattern")
    private String functionalTestPattern = "it/**";
    @Parameter(property="project.build.testOutputDirectory", required=true)
    private File testClassesDirectory;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip = false;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests = false;
    @Parameter(property="skipITs", defaultValue="false")
    private boolean skipITs = false;
    @Parameter(property="http.port", defaultValue="80")
    protected int httpPort;
    @Parameter(property="pdk.username", defaultValue="admin")
    protected String pdkUsername;
    @Parameter(property="pdk.password", defaultValue="admin")
    protected String pdkPassword;
    @Parameter
    protected List<ProductArtifact> deployArtifacts = new ArrayList<ProductArtifact>();
    @Parameter
    protected String category;

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)this.server)) {
            this.getLog().error((CharSequence)"server is not set!");
            return;
        }
        if (null == this.contextPath || StringUtils.trim((String)this.contextPath).equals("/")) {
            this.contextPath = "";
        }
        if (this.httpPort < 1) {
            this.httpPort = 80;
        }
        if (!this.shouldBuildTestPlugin()) {
            this.getLog().info((CharSequence)"shouldBuildTestPlugin is false... skipping test run!");
            return;
        }
        MavenProject project = this.getMavenContext().getProject();
        project.getArtifact().setArtifactHandler(this.artifactHandlerManager.getArtifactHandler("jar"));
        if (!new File(this.testClassesDirectory, "it").exists()) {
            this.getLog().info((CharSequence)"No integration tests found");
            return;
        }
        if (this.skipTests || this.testsSkip || this.skipITs) {
            this.getLog().info((CharSequence)"Integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        String pluginJar = this.targetDirectory.getAbsolutePath() + "/" + this.finalName + ".jar";
        this.runTestsForTestGroup("__no_test_group__", goals, pluginJar, this.copy(this.systemPropertyVariables));
    }

    private Map<String, Object> copy(Map<String, Object> systemPropertyVariables) {
        return new HashMap<String, Object>(systemPropertyVariables);
    }

    private String getBaseUrl(String server, int actualHttpPort, String contextPath) {
        String port = actualHttpPort != 80 ? ":" + actualHttpPort : "";
        String string = server = server.startsWith("http") ? server : "http://" + server;
        if (!contextPath.startsWith("/") && StringUtils.isNotBlank((CharSequence)contextPath)) {
            contextPath = "/" + contextPath;
        }
        return server + port + contextPath;
    }

    private void runTestsForTestGroup(String testGroupId, MavenGoals goals, String pluginJar, Map<String, Object> systemProperties) throws MojoExecutionException {
        try {
            MavenContext ctx = this.getMavenContext();
            Build build = ctx.getProject().getBuild();
            File buildDir = new File(build.getDirectory());
            File testClassesDir = new File(build.getTestOutputDirectory());
            List<String> wiredTestClasses = this.getWiredTestClassnames(testClassesDir);
            if (wiredTestClasses.isEmpty()) {
                this.getLog().info((CharSequence)"No wired integration tests found, skipping remote testing...");
                return;
            }
            ArrayList<String> includes = new ArrayList<String>(wiredTestClasses.size());
            for (String wiredClass : wiredTestClasses) {
                String includePath = wiredClass.replaceAll("\\.", "/");
                includes.add(includePath + "*");
            }
            List<String> excludes = Collections.emptyList();
            systemProperties.put("http.port", this.httpPort);
            systemProperties.put("context.path", this.contextPath);
            systemProperties.put("plugin.jar", pluginJar);
            if (!systemProperties.containsKey("baseurl")) {
                systemProperties.put("baseurl", this.getBaseUrl(this.server, this.httpPort, this.contextPath));
            }
            Map<ProductArtifact, File> frameworkFiles = this.getFrameworkFiles();
            File junitFile = null;
            for (Map.Entry<ProductArtifact, File> entry : frameworkFiles.entrySet()) {
                ProductArtifact artifact = entry.getKey();
                File artifactFile = entry.getValue();
                if (!artifactFile.getName().startsWith("org.apache.servicemix.bundles.junit")) continue;
                junitFile = artifactFile;
                frameworkFiles.remove(artifact);
                break;
            }
            File mainPlugin = new File(buildDir, this.finalName + ".jar");
            File testPlugin = new File(buildDir, this.finalName + "-tests.jar");
            if (null == junitFile || !junitFile.exists()) {
                throw new MojoExecutionException("couldn't find junit!!!!");
            }
            this.installPluginFileIfNotInstalled(junitFile);
            for (Map.Entry<ProductArtifact, File> pluginEntry : frameworkFiles.entrySet()) {
                this.installPluginFileIfNotInstalled(pluginEntry.getValue());
            }
            this.installPluginFile(mainPlugin);
            this.installPluginFile(testPlugin);
            goals.runIntegrationTests("group-" + testGroupId, "remote", includes, excludes, systemProperties, this.targetDirectory, this.category, false);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error running remote tests...", e);
        }
    }

    private void installPluginFileIfNotInstalled(File pluginFile) throws IOException, MojoExecutionException {
        this.getLog().info((CharSequence)("checking to see if we need to install " + pluginFile.getName()));
        JarFile jar = new JarFile(pluginFile);
        Manifest mf = jar.getManifest();
        String pluginKey = null;
        String pluginVersion = null;
        if (null != mf) {
            pluginKey = mf.getMainAttributes().getValue("Bundle-SymbolicName");
            pluginVersion = mf.getMainAttributes().getValue("Bundle-Version");
            this.getLog().info((CharSequence)("pluginKet from manifest is: " + pluginKey));
        } else {
            this.getLog().info((CharSequence)"no manifext found for plugin!!");
        }
        if (StringUtils.isBlank((CharSequence)pluginKey)) {
            this.getLog().info((CharSequence)"no plugin key found, installing without check...");
            this.installPluginFile(pluginFile);
        } else {
            boolean foundPlugin = false;
            ApacheHttpClientConfig config = new ApacheHttpClientConfig();
            config.readTimeout(1800000);
            BasicAuthSecurityHandler basicAuthHandler = new BasicAuthSecurityHandler();
            basicAuthHandler.setUserName(this.pdkUsername);
            basicAuthHandler.setPassword(this.pdkPassword);
            config.handlers(new ClientHandler[]{basicAuthHandler});
            config.followRedirects(true);
            RestClient client = new RestClient((ClientConfig)config);
            URI uri = UriBuilder.fromPath((String)(this.contextPath + "/rest/plugins/1.0/" + pluginKey + "-key")).scheme("http").host(this.server).port(this.httpPort).build(new Object[0]);
            this.getLog().info((CharSequence)("looking up plugin from: " + uri.toURL().toString()));
            Resource resource = client.resource(uri);
            ClientResponse response = resource.get();
            if (response.getStatusCode() == HttpStatus.NOT_FOUND.getCode()) {
                this.getLog().info((CharSequence)"got a 404, trying again with version tacked on...");
                uri = UriBuilder.fromPath((String)(this.contextPath + "/rest/plugins/1.0/" + pluginKey + "-" + pluginVersion + "-key")).scheme("http").host(this.server).port(this.httpPort).build(new Object[0]);
                this.getLog().info((CharSequence)("looking up plugin from: " + uri.toURL().toString()));
                resource = client.resource(uri);
                response = resource.get();
                if (response.getStatusCode() != HttpStatus.NOT_FOUND.getCode()) {
                    this.getLog().info((CharSequence)"found the plugin!!");
                    foundPlugin = true;
                }
            } else {
                this.getLog().info((CharSequence)"found the plugin!!");
                foundPlugin = true;
            }
            if (!foundPlugin) {
                this.getLog().info((CharSequence)"didn't find the plugin so I'm installing it...");
                this.installPluginFile(pluginFile);
            }
        }
    }

    private void installPluginFile(File pluginFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)"trying to install plugin with the following properties:");
        this.getLog().info((CharSequence)("pluginFile: " + pluginFile.getAbsolutePath()));
        this.getLog().info((CharSequence)("pluginKey: " + pluginFile.getName()));
        this.getLog().info((CharSequence)("server: " + this.server));
        this.getLog().info((CharSequence)("httpPort: " + this.httpPort));
        this.getLog().info((CharSequence)("contextPath: " + this.contextPath));
        this.getLog().info((CharSequence)("username: " + this.pdkUsername));
        this.getMavenGoals().installPlugin(new PdkParams.Builder().pluginFile(pluginFile.getAbsolutePath()).pluginKey(pluginFile.getName()).server(this.server).port(this.httpPort).contextPath(this.contextPath).username(this.pdkUsername).password(this.pdkPassword).build());
    }

    private List<String> getWiredTestClassnames(File testClassesDir) {
        MavenProject prj = this.getMavenContext().getProject();
        ArrayList<String> wiredClasses = new ArrayList<String>();
        if (testClassesDir.exists()) {
            Collection classFiles = FileUtils.listFiles((File)testClassesDir, (String[])new String[]{"class"}, (boolean)true);
            for (File classFile : classFiles) {
                String className = ClassUtils.getClassnameFromFile(classFile, prj.getBuild().getTestOutputDirectory());
                WiredTestInfo wiredInfo = ClassUtils.getWiredTestInfo(classFile);
                if (!wiredInfo.isWiredTest()) continue;
                wiredClasses.add(className);
            }
        }
        return wiredClasses;
    }

    private Map<ProductArtifact, File> getFrameworkFiles() throws MojoExecutionException {
        ArrayList<ProductArtifact> pluginsToDeploy = new ArrayList<ProductArtifact>(this.getTestFrameworkPlugins());
        pluginsToDeploy.addAll(this.deployArtifacts);
        HashMap<ProductArtifact, File> artifactFileMap = new HashMap<ProductArtifact, File>(pluginsToDeploy.size());
        try {
            File tmpDir = new File(this.getMavenContext().getProject().getBuild().getDirectory(), "tmp-artifacts");
            FileUtils.forceMkdir((File)tmpDir);
            FileUtils.cleanDirectory((File)tmpDir);
            this.getMavenGoals().copyPlugins(tmpDir, pluginsToDeploy);
            for (File file : tmpDir.listFiles()) {
                final File artifactFile = file;
                Collection filtered = Collections2.filter(pluginsToDeploy, (Predicate)new Predicate<ProductArtifact>(){

                    public boolean apply(@Nullable ProductArtifact productArtifact) {
                        return artifactFile.getName().startsWith(productArtifact.getArtifactId());
                    }
                });
                if (filtered.isEmpty()) continue;
                artifactFileMap.put((ProductArtifact)filtered.iterator().next(), artifactFile);
            }
            return artifactFileMap;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying framework files", e);
        }
    }
}

