/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraDatabase;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class JiraDatabaseMssqlImpl
extends AbstractJiraDatabase {
    private static final String DROP_DATABASE = "USE [master]; \nIF EXISTS(SELECT * FROM SYS.DATABASES WHERE name='%s') \nDROP DATABASE [%s];\n";
    private static final String DROP_USER = "USE [master]; \nIF EXISTS(SELECT * FROM SYS.SERVER_PRINCIPALS WHERE name = '%s') \nDROP LOGIN %s; \n";
    private static final String CREATE_DATABASE = "USE [master]; \n CREATE DATABASE [%s]; \n";
    private static final String CREATE_USER = "USE [master]; \n CREATE LOGIN %s WITH PASSWORD = '%s'; \n";
    private static final String GRANT_PERMISSION = "USE [%s];\nCREATE USER %s FROM LOGIN %s; \nEXEC SP_ADDROLEMEMBER 'DB_OWNER', '%s'; \nALTER LOGIN %s WITH DEFAULT_DATABASE = [%s]; \n";

    public JiraDatabaseMssqlImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String dropDatabase() throws MojoExecutionException {
        String databaseName = this.getDatabaseName(this.getDataSource().getUrl());
        return String.format(DROP_DATABASE, databaseName, databaseName);
    }

    @Override
    protected String dropUser() {
        String username = this.getDataSource().getUsername();
        return String.format(DROP_USER, username, username);
    }

    @Override
    protected String createDatabase() throws MojoExecutionException {
        return String.format(CREATE_DATABASE, this.getDatabaseName(this.getDataSource().getUrl()));
    }

    @Override
    protected String createUser() {
        return String.format(CREATE_USER, this.getDataSource().getUsername(), this.getDataSource().getPassword());
    }

    @Override
    protected String grantPermissionForUser() throws MojoExecutionException {
        String username = this.getDataSource().getUsername();
        String databaseName = this.getDatabaseName(this.getDataSource().getUrl());
        return String.format(GRANT_PERMISSION, databaseName, username, username, username, username, databaseName);
    }

    @Override
    public Xpp3Dom getConfigDatabaseTool() throws MojoExecutionException {
        Xpp3Dom configDatabaseTool = null;
        if (ImportMethod.SQLCMD.equals((Object)ImportMethod.getValueOf(this.getDataSource().getImportMethod()))) {
            String databaseName = this.getDatabaseName(this.getDataSource().getUrl());
            String restoreAndGrantPermission = "\"RESTORE DATABASE [" + databaseName + "] FROM DISK='" + this.getDataSource().getDumpFilePath() + "' WITH REPLACE; " + this.grantPermissionForUser() + " \"";
            this.getLog().info((CharSequence)("MSSQL restore database and grant permission: " + restoreAndGrantPermission));
            configDatabaseTool = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "Sqlcmd"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name("argument"), "-s"), MojoExecutor.element(MojoExecutor.name("argument"), "localhost"), MojoExecutor.element(MojoExecutor.name("argument"), "-Q"), MojoExecutor.element(MojoExecutor.name("argument"), restoreAndGrantPermission)));
        }
        return configDatabaseTool;
    }

    @Override
    protected String getDatabaseName(String url) throws MojoExecutionException {
        try {
            Class.forName(this.getDataSource().getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Could not load MSSQL database library to classpath");
        }
        try {
            Driver driver = DriverManager.getDriver(url);
            DriverPropertyInfo[] driverPropertyInfos = driver.getPropertyInfo(url, null);
            if (null != driverPropertyInfos) {
                for (DriverPropertyInfo driverPropertyInfo : driverPropertyInfos) {
                    if (!"DATABASENAME".equalsIgnoreCase(driverPropertyInfo.name)) continue;
                    return driverPropertyInfo.value;
                }
            }
        }
        catch (SQLException e) {
            throw new MojoExecutionException("Could not detect database name from url: " + url);
        }
        return null;
    }

    @Override
    public Xpp3Dom getPluginConfiguration() throws MojoExecutionException {
        String sql = this.dropDatabase() + this.dropUser() + this.createDatabase() + this.createUser() + this.grantPermissionForUser();
        this.getLog().info((CharSequence)("MSSQL initializarion database sql: " + sql));
        Xpp3Dom pluginConfiguration = this.systemDatabaseConfiguration();
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("sqlCommand"), sql).toDom());
        return pluginConfiguration;
    }
}

