/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static File file(String parent, String ... kids) {
        return FileUtils.file(new File(parent), kids);
    }

    public static File file(File parent, String ... kids) {
        File cur = parent;
        for (String kid : kids) {
            cur = new File(cur, kid);
        }
        return cur;
    }

    public static boolean doesFileNameMatchArtifact(String fileName, String artifactId) {
        String pattern = "^" + artifactId + "-\\d.*$";
        return fileName.matches(pattern);
    }

    public static void deleteDir(File dir) {
        if (dir.exists()) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)dir);
        }
    }

    public static String fixWindowsSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static void cleanDirectory(File directory, FileFilter filter) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles(filter);
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                org.apache.commons.io.FileUtils.forceDelete((File)file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void copyDirectory(File source, File destination, boolean preserveFileAttrs) throws IOException {
        if (!destination.mkdirs() && !destination.isDirectory()) {
            throw new IOException("Destination '" + destination + "' directory cannot be created");
        }
        File[] srcFiles = source.listFiles();
        for (File srcFile : srcFiles = srcFiles != null ? srcFiles : new File[]{}) {
            File dstFile = new File(destination, srcFile.getName());
            if (srcFile.isDirectory()) {
                FileUtils.copyDirectory(srcFile, dstFile, preserveFileAttrs);
                continue;
            }
            org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)dstFile, (boolean)preserveFileAttrs);
            if (!preserveFileAttrs || !srcFile.canExecute()) continue;
            dstFile.setExecutable(true);
        }
    }

    @ParametersAreNonnullByDefault
    public static String readFileToString(String name, Class<?> loadingClass, Charset encoding) {
        InputStream fileStream = loadingClass.getResourceAsStream(name);
        Objects.requireNonNull(fileStream, String.format("Could not find '%s' on classpath of %s", name, loadingClass.getName()));
        try {
            return IOUtils.toString((InputStream)fileStream, (Charset)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

