/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps;

import com.atlassian.maven.plugins.amps.AbstractTestGroupsHandlerMojo;
import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.LibArtifact;
import com.atlassian.maven.plugins.amps.MavenGoals;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.ProductExecution;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.atlassian.maven.plugins.amps.product.jira.JiraDatabaseType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="prepare-database", requiresDependencyResolution=ResolutionScope.TEST)
public class PrepareDatabaseMojo
extends AbstractTestGroupsHandlerMojo {
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean testsSkip;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="db.dump.file.path")
    private String dumpFilePath;
    @Parameter(property="import.method")
    private String importMethod;
    @Parameter(property="db.default.database")
    private String defaultDatabase;
    @Parameter(property="db.system.username")
    private String systemUsername;
    @Parameter(property="db.system.password")
    private String systemPassword;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.testsSkip || this.skipTests) {
            this.getLog().info((CharSequence)"Pre integration tests skipped");
            return;
        }
        MavenGoals goals = this.getMavenGoals();
        List<ProductExecution> productExecutions = this.getProductExecutions();
        if (productExecutions != null) {
            block4: for (ProductExecution productExecution : productExecutions) {
                if (!"jira".equals(productExecution.getProduct().getId())) continue;
                List<DataSource> dataSources = productExecution.getProduct().getDataSources();
                switch (dataSources.size()) {
                    case 1: {
                        DataSource dataSource = dataSources.get(0);
                        JiraDatabaseType databaseType = JiraDatabaseType.getDatabaseType(dataSource).orElseThrow(() -> new MojoExecutionException("Could not detect database type for dataSource: " + dataSource));
                        List<ProductArtifact> libArtifacts = productExecution.getProduct().getLibArtifacts();
                        if (libArtifacts == null || libArtifacts.isEmpty()) {
                            throw new MojoExecutionException("Product library artifact is empty, please provide library for database: " + (Object)((Object)databaseType));
                        }
                        for (ProductArtifact productArtifact : libArtifacts) {
                            dataSource.getLibArtifacts().add(new LibArtifact(productArtifact.getGroupId(), productArtifact.getArtifactId(), productArtifact.getVersion()));
                        }
                        this.populateDatasourceParameter(dataSource);
                        goals.runPreIntegrationTest(dataSource);
                        continue block4;
                    }
                    case 0: {
                        this.getLog().info((CharSequence)"No dataSource configured for pre-integration-test");
                        continue block4;
                    }
                }
                this.getLog().info((CharSequence)("Multiple dataSources not supported. Configuration has these " + dataSources.size() + " dataSources:"));
                for (DataSource dbSource : dataSources) {
                    this.getLog().info((CharSequence)("Database URL: " + dbSource.getUrl()));
                }
            }
        }
    }

    private void populateDatasourceParameter(DataSource dataSource) {
        if (StringUtils.isNotEmpty((CharSequence)this.defaultDatabase)) {
            dataSource.setDefaultDatabase(this.defaultDatabase);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.systemUsername)) {
            dataSource.setSystemUsername(this.systemUsername);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.systemPassword)) {
            dataSource.setSystemPassword(this.systemPassword);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.dumpFilePath)) {
            dataSource.setDumpFilePath(this.dumpFilePath);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.importMethod)) {
            dataSource.setImportMethod(this.importMethod);
        } else {
            dataSource.setImportMethod(ImportMethod.SQL.getMethod());
        }
        this.getLog().info((CharSequence)("Pre-integration-test import method: " + dataSource.getImportMethod()));
    }
}

