/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product;

import com.atlassian.maven.plugins.amps.Application;
import com.atlassian.maven.plugins.amps.Product;
import com.atlassian.maven.plugins.amps.ProductArtifact;
import com.atlassian.maven.plugins.amps.product.GroupArtifactPair;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class ApplicationMapper {
    private Map<String, Map<String, GroupArtifactPair>> applicationKeys;

    ApplicationMapper(Map<String, Map<String, GroupArtifactPair>> applicationKeys) {
        this.applicationKeys = applicationKeys;
    }

    List<ProductArtifact> provideApplications(Product product) {
        return (List)Option.option(this.applicationKeys.get(product.getId())).map(applicationKeysForProduct -> {
            Predicate<Application> isApplicationSupportedByProduct = application -> {
                String applicationKey = application.getApplicationKey();
                return applicationKeysForProduct.containsKey(applicationKey);
            };
            Function<Application, ProductArtifact> toProductArtifact = application -> {
                String applicationKey = application.getApplicationKey();
                GroupArtifactPair groupArtifactPair = (GroupArtifactPair)applicationKeysForProduct.get(applicationKey);
                return groupArtifactPair.createProductArtifactWithVersion(application.getVersion());
            };
            return product.getApplications().stream().filter(isApplicationSupportedByProduct).map(toProductArtifact).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }).getOrElse(Collections.emptyList());
    }
}

