/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook;

import com.atlassian.plugin.osgi.hook.InternalPackageDetector;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;

public class InternalPluginDetector {
    private final Set<String> bundledPluginKeys;
    private final InternalPackageDetector internalPackageDetector;

    public InternalPluginDetector(Set<String> bundledPluginKeys, Set<String> publicPackages, Set<String> publicPackagesExcludes) {
        this.bundledPluginKeys = bundledPluginKeys;
        this.internalPackageDetector = new InternalPackageDetector(publicPackages, publicPackagesExcludes);
    }

    public boolean isInternalCapability(BundleCapability candidate) {
        Bundle exportingBundle = candidate.getRevision().getBundle();
        if (this.isInternalPluginOrSystemBundle(exportingBundle)) {
            return this.internalPackageDetector.isInternalPackage(candidate);
        }
        return false;
    }

    public boolean isInternalPluginOrSystemBundle(Bundle bundle) {
        boolean systemBundle = this.isSystemBundle(bundle);
        boolean internalPlugin = this.isInternalPlugin(bundle);
        return internalPlugin || systemBundle;
    }

    public boolean isInternalPlugin(Bundle bundle) {
        String pluginKey = this.getPluginKeyOrSymbolicName(bundle);
        return pluginKey.startsWith("com.atlassian") || this.bundledPluginKeys.contains(pluginKey);
    }

    public boolean isSystemBundle(Bundle bundle) {
        return bundle.getBundleId() == 0L;
    }

    public String getPluginKeyOrSymbolicName(Bundle bundle) {
        String atlassianPluginKey = (String)bundle.getHeaders().get("Atlassian-Plugin-Key");
        if (atlassianPluginKey == null) {
            return bundle.getSymbolicName();
        }
        return atlassianPluginKey;
    }
}

