/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.servlet.PluginHttpSessionWrapper;
import com.atlassian.plugin.servlet.descriptors.BaseServletModuleDescriptor;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class PluginHttpRequestWrapper
extends HttpServletRequestWrapper {
    private final String basePath;
    private HttpServletRequest delegate;
    private boolean asyncSupported;

    public PluginHttpRequestWrapper(HttpServletRequest request, BaseServletModuleDescriptor<?> descriptor) {
        super(request);
        this.delegate = request;
        this.basePath = this.findBasePath(descriptor);
        this.asyncSupported = request.isAsyncSupported() && descriptor.isAsyncSupported();
    }

    public String getServletPath() {
        String servletPath = super.getServletPath();
        if (this.basePath != null) {
            servletPath = servletPath + this.basePath;
        }
        return servletPath;
    }

    public String getPathInfo() {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null && this.basePath != null) {
            if (this.basePath.equals(pathInfo)) {
                return null;
            }
            if (pathInfo.startsWith(this.basePath)) {
                return pathInfo.substring(this.basePath.length());
            }
        }
        return pathInfo;
    }

    private String findBasePath(BaseServletModuleDescriptor<?> descriptor) {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null) {
            for (String basePath : descriptor.getPaths()) {
                if (!basePath.equals(pathInfo)) continue;
                return basePath;
            }
            String[] pathInfoComponents = StringUtils.split((String)pathInfo, (char)'/');
            for (String basePath : descriptor.getPaths()) {
                String mappingRootPath;
                String[] mappingRootPathComponents;
                if (!this.isPathMapping(basePath) || !PluginHttpRequestWrapper.arrayStartsWith(pathInfoComponents, mappingRootPathComponents = StringUtils.split((String)(mappingRootPath = this.getMappingRootPath(basePath)), (char)'/'))) continue;
                return mappingRootPath;
            }
        }
        return null;
    }

    private static boolean arrayStartsWith(String[] array, String[] prefixArray) {
        if (prefixArray.length > array.length) {
            return false;
        }
        for (int i = prefixArray.length - 1; i >= 0; --i) {
            if (prefixArray[i].equals(array[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isPathMapping(String path) {
        return path.startsWith("/") && path.endsWith("/*");
    }

    private String getMappingRootPath(String pathMapping) {
        return pathMapping.substring(0, pathMapping.length() - "/*".length());
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.delegate.getSession(create);
        if (session == null) {
            return null;
        }
        return session instanceof PluginHttpSessionWrapper ? session : new PluginHttpSessionWrapper(session);
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public AsyncContext startAsync() {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("One of the plugins in the filter chain does not support async");
        }
        return super.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("One of the plugins in the filter chain does not support async");
        }
        return super.startAsync(servletRequest, servletResponse);
    }
}

