/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.annotation.Nonnull;
import org.dom4j.Element;

public class WebItemProviderModuleDescriptor
extends AbstractModuleDescriptor<WebItemProvider> {
    private final WebInterfaceManager webInterfaceManager;
    private Supplier<WebItemProvider> itemSupplier;
    private String section;

    public WebItemProviderModuleDescriptor(ModuleFactory moduleFactory, WebInterfaceManager webInterfaceManager) {
        super(moduleFactory);
        this.webInterfaceManager = webInterfaceManager;
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@class").withError("The web item provider class is required.")});
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@section").withError("Must provide a section that items should be added to.")});
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.itemSupplier = Suppliers.memoize(() -> (WebItemProvider)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this));
        this.section = element.attributeValue("section");
    }

    public String getSection() {
        return this.section;
    }

    public WebItemProvider getModule() {
        return (WebItemProvider)this.itemSupplier.get();
    }

    public void enabled() {
        super.enabled();
        this.webInterfaceManager.refresh();
    }

    public void disabled() {
        super.disabled();
        this.webInterfaceManager.refresh();
    }
}

