/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.ContextBatch;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceBatchParams;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.ConditionsCache;
import com.atlassian.plugin.webresource.http.Router;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.commons.collections.CollectionUtils;

public class ContextBatchOperations {
    private static final String CONTEXT_SEPARATOR = ",";
    private static final String CONTEXT_SUBTRACTION = "-";
    private PluginResourceLocator pluginResourceLocator;
    private final WebResourceFilter filter;

    ContextBatchOperations(PluginResourceLocator pluginResourceLocator, WebResourceFilter filter) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.filter = filter;
    }

    ContextBatch merge(Collection<ContextBatch> batchesToMerge) {
        if (CollectionUtils.isEmpty(batchesToMerge)) {
            return null;
        }
        if (batchesToMerge.size() == 1) {
            return batchesToMerge.iterator().next();
        }
        StringBuilder mergedKey = new StringBuilder();
        LinkedHashSet<String> includedContexts = new LinkedHashSet<String>();
        HashSet<WebResourceModuleDescriptor> resources = new HashSet<WebResourceModuleDescriptor>();
        ArrayListMultimap batchResourceParams = ArrayListMultimap.create();
        for (ContextBatch batch : batchesToMerge) {
            if (!Iterables.isEmpty(batch.getExcludedContexts())) {
                throw new IllegalArgumentException("The ContextBatch " + batch.getKey() + " has excludedContexts.");
            }
            mergedKey.append(batch.getKey()).append(CONTEXT_SEPARATOR);
            includedContexts.addAll(batch.getContexts());
            Iterables.addAll(resources, batch.getResources());
            batchResourceParams.putAll(batch.getResourceParams());
        }
        mergedKey.deleteCharAt(mergedKey.length() - 1);
        return new ContextBatch(this.pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt(), mergedKey.toString(), new ArrayList<String>(includedContexts), null, resources, (ListMultimap<PluginResourceBatchParams, UrlParameters>)batchResourceParams);
    }

    ContextBatch subtract(ContextBatch operand, Collection<ContextBatch> batchesToSubtract, ConditionState conditionsRun, ConditionsCache conditionsCache) {
        if (CollectionUtils.isEmpty(batchesToSubtract)) {
            return operand;
        }
        LinkedHashSet<String> excludedContexts = new LinkedHashSet<String>();
        Iterables.addAll(excludedContexts, operand.getExcludedContexts());
        LinkedHashSet<WebResourceModuleDescriptor> resources = new LinkedHashSet<WebResourceModuleDescriptor>();
        Iterables.addAll(resources, operand.getResources());
        for (ContextBatch subtract : batchesToSubtract) {
            if (!Iterables.isEmpty(subtract.getExcludedContexts())) {
                throw new IllegalArgumentException("The ContextBatch " + subtract.getKey() + " has excludedContexts.");
            }
            Iterables.addAll(excludedContexts, subtract.getContexts());
            Iterable<WebResourceModuleDescriptor> subtractResources = subtract.getResources();
            for (WebResourceModuleDescriptor resource : subtractResources) {
                resources.remove((Object)resource);
            }
        }
        String key = Router.encodeContexts(operand.getContexts(), excludedContexts);
        ContextBatch subtractionResult = new ContextBatch(this.pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt(), key, operand.getContexts(), excludedContexts, resources, null);
        for (WebResourceModuleDescriptor resource : resources) {
            for (PluginResource pluginResource : this.pluginResourceLocator.getPluginResources(resource.getCompleteKey(), conditionsRun, conditionsCache)) {
                if (!this.filter.matches(pluginResource.getResourceName())) continue;
                subtractionResult.addResourceType(pluginResource);
            }
        }
        return subtractionResult;
    }
}

