/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.bigpipe;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.webresource.bigpipe.FutureCompletionService;
import com.atlassian.plugin.webresource.bigpipe.Key;
import com.atlassian.plugin.webresource.bigpipe.KeyedValue;
import com.atlassian.plugin.webresource.util.ConsList;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.atomic.AtomicReference;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@Internal
public class QueueFutureCompletionService<V>
implements FutureCompletionService<V> {
    private final AtomicReference<InnerQueue> queue = new AtomicReference(new OpenInnerQueue());

    @Override
    public FutureCompletionService<V> add(String key, Promise<V> promise) {
        ((InnerQueue)this.queue.get()).add(key, promise);
        return this;
    }

    @Override
    public void destroy(boolean mayInterruptIfRunning) {
        InnerQueue inner = (InnerQueue)this.queue.getAndSet(new ClosedInnerQueue());
        inner.cancelPending(mayInterruptIfRunning);
    }

    @Override
    public Iterable<KeyedValue<V>> poll() {
        return ((InnerQueue)this.queue.get()).poll();
    }

    @Override
    public Iterable<KeyedValue<V>> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return ((InnerQueue)this.queue.get()).poll(timeout, unit);
    }

    @Override
    public boolean isComplete() {
        return ((InnerQueue)this.queue.get()).isComplete();
    }

    private static final class PendingPromises<A> {
        private final AtomicReference<ConsList<Promise<A>>> promises = new AtomicReference(ConsList.empty());

        private PendingPromises() {
        }

        void add(final Promise<A> p) {
            this.promises.update(new Function<ConsList<Promise<A>>, ConsList<Promise<A>>>(){

                public ConsList<Promise<A>> apply(ConsList<Promise<A>> input) {
                    return input.prepend(p);
                }
            });
        }

        void remove(final Promise<A> p) {
            this.promises.update(new Function<ConsList<Promise<A>>, ConsList<Promise<A>>>(){

                public ConsList<Promise<A>> apply(ConsList<Promise<A>> input) {
                    return input.remove(p);
                }
            });
        }

        boolean isEmpty() {
            return Iterables.isEmpty((Iterable)((Iterable)this.promises.get()));
        }

        Iterable<Promise<A>> getAllAndRemove() {
            return (Iterable)this.promises.getAndSet(ConsList.empty());
        }
    }

    private static final class OpenInnerQueue<V>
    implements InnerQueue<V> {
        private final BlockingQueue<KeyedValue<V>> completionQueue = new LinkedBlockingQueue<KeyedValue<V>>();
        private final PendingPromises<V> pendingPromises = new PendingPromises();

        private OpenInnerQueue() {
        }

        @Override
        public void cancelPending(boolean mayInterruptIfRunning) {
            for (Promise<V> promise : this.pendingPromises.getAllAndRemove()) {
                promise.cancel(mayInterruptIfRunning);
            }
        }

        @Override
        public void add(final String key, final Promise<V> promise) {
            this.pendingPromises.add(promise);
            promise.then(new FutureCallback<V>(){

                public void onSuccess(V result) {
                    OpenInnerQueue.this.complete(key, promise, result);
                }

                public void onFailure(Throwable t) {
                    OpenInnerQueue.this.complete(key, promise, t);
                }
            });
        }

        @Override
        public boolean isComplete() {
            return this.pendingPromises.isEmpty() && this.completionQueue.isEmpty();
        }

        private void complete(Promise<V> promise, KeyedValue<V> value) {
            this.completionQueue.add(value);
            this.pendingPromises.remove(promise);
        }

        private void complete(String key, Promise<V> promise, V result) {
            this.complete(promise, KeyedValue.success(Key.of(key), result));
        }

        private void complete(String key, Promise<V> promise, Throwable t) {
            if (!(t instanceof CancellationException)) {
                if (t instanceof Exception) {
                    this.complete(promise, KeyedValue.fail(Key.of(key), (Exception)t));
                } else {
                    this.pendingPromises.remove(promise);
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new AssertionError((Object)t);
                }
            }
        }

        @Override
        public Iterable<KeyedValue<V>> poll() {
            return this.getResult((KeyedValue)this.completionQueue.poll());
        }

        @Override
        public Iterable<KeyedValue<V>> poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.getResult(this.completionQueue.poll(timeout, unit));
        }

        private Iterable<KeyedValue<V>> getResult(KeyedValue<V> promise) {
            LinkedList results = Lists.newLinkedList();
            if (null != promise) {
                results.add(promise);
            }
            this.completionQueue.drainTo(results);
            return results;
        }
    }

    private static final class ClosedInnerQueue<V>
    implements InnerQueue<V> {
        private ClosedInnerQueue() {
        }

        @Override
        public void add(String key, Promise<V> promise) {
            throw new IllegalStateException("Cannot add a promise after this queue has been destroyed");
        }

        @Override
        public void cancelPending(boolean mayInterruptIfRunning) {
        }

        @Override
        public Iterable<KeyedValue<V>> poll() {
            return Collections.emptyList();
        }

        @Override
        public Iterable<KeyedValue<V>> poll(long timeout, TimeUnit unit) throws InterruptedException {
            return Collections.emptyList();
        }

        @Override
        public boolean isComplete() {
            return true;
        }
    }

    private static interface InnerQueue<V> {
        public void add(String var1, Promise<V> var2);

        public void cancelPending(boolean var1);

        public Iterable<KeyedValue<V>> poll();

        public Iterable<KeyedValue<V>> poll(long var1, TimeUnit var3) throws InterruptedException;

        public boolean isComplete();
    }
}

