/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractWebResourceFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class JavascriptWebResource
extends AbstractWebResourceFormatter {
    private final boolean isAmdEnabled;
    private static final List<String> HANDLED_PARAMETERS = Arrays.asList("charset", "data-wrm-key", "data-wrm-batch-type", "data-initially-rendered", "async");

    @Deprecated
    public JavascriptWebResource() {
        this(false);
    }

    public JavascriptWebResource(boolean isAmdEnabled) {
        this.isAmdEnabled = isAmdEnabled;
    }

    @Override
    public boolean matches(String name) {
        return name != null && (name.endsWith(".js") || this.isAmdEnabled && name.endsWith(".soy"));
    }

    @Override
    public String formatResource(String url, Map<String, String> attributes) {
        return this.formatResource(url, attributes, false);
    }

    public String formatResource(String url, Map<String, String> attributes, boolean enableDeferJsAttribute) {
        StringBuilder buffer = new StringBuilder("<script type=\"text/javascript\" ");
        buffer.append("src=\"").append(StringEscapeUtils.escapeHtml((String)url)).append("\" ");
        if (enableDeferJsAttribute && !attributes.containsKey("async")) {
            buffer.append("defer ");
        }
        buffer.append(StringUtils.join(this.getParametersAsAttributes(attributes).iterator(), (String)" "));
        buffer.append("></script>\n");
        if (attributes.containsKey("conditionalComment")) {
            String condition = attributes.get("conditionalComment");
            buffer.insert(0, "<!--[if " + condition + "]>\n");
            buffer.append("<![endif]-->\n");
        } else if (BooleanUtils.toBoolean((String)attributes.get("ieonly"))) {
            buffer.insert(0, "<!--[if IE]>\n");
            buffer.append("<![endif]-->\n");
        }
        return buffer.toString();
    }

    @Override
    protected List<String> getAttributeParameters() {
        return HANDLED_PARAMETERS;
    }
}

