/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.legacy;

import com.atlassian.plugin.webresource.legacy.BatchPluginResource;
import com.atlassian.plugin.webresource.legacy.ModuleDescriptorStub;
import com.atlassian.plugin.webresource.legacy.PluginResource;
import com.atlassian.plugin.webresource.legacy.PluginResourceLocator;
import com.atlassian.plugin.webresource.legacy.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.legacy.SuperBatchPluginResource;
import java.util.ArrayList;

public class SuperBatchBuilder {
    private final ResourceDependencyResolver dependencyResolver;
    private final PluginResourceLocator pluginResourceLocator;

    public SuperBatchBuilder(ResourceDependencyResolver dependencyResolver, PluginResourceLocator pluginResourceLocator) {
        this.dependencyResolver = dependencyResolver;
        this.pluginResourceLocator = pluginResourceLocator;
    }

    public Iterable<PluginResource> build() {
        Iterable<ModuleDescriptorStub> superBatchModuleKeys = this.dependencyResolver.getSuperBatchDependencies();
        ArrayList<PluginResource> resources = new ArrayList<PluginResource>();
        SuperBatchPluginResource superBatchPluginResource = new SuperBatchPluginResource();
        boolean isEmpty = true;
        for (ModuleDescriptorStub moduleDescriptor : superBatchModuleKeys) {
            for (PluginResource pluginResource : this.pluginResourceLocator.getPluginResources(moduleDescriptor.getCompleteKey())) {
                if (!(pluginResource instanceof BatchPluginResource)) continue;
                superBatchPluginResource.addBatchedWebResourceDescriptor(((BatchPluginResource)pluginResource).getModuleCompleteKey());
                isEmpty &= false;
            }
        }
        if (!isEmpty) {
            resources.add(superBatchPluginResource);
        }
        return resources;
    }
}

