/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.cache.filecache.impl;

import com.atlassian.plugin.cache.filecache.Cache;
import com.atlassian.plugin.cache.filecache.impl.OneStreamCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamsCache {
    private Logger log = LoggerFactory.getLogger(OneStreamCache.class);
    private static final String CLIENT_ABORT_EXCEPTION = "org.apache.catalina.connector.ClientAbortException";
    private final Object lock = new Object();
    private int concurrentCount;
    private State state = State.UNCACHED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWhenPossible(Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.UNCACHED) {
                this.state = State.DELETED;
            } else if (this.state == State.CACHED) {
                this.state = State.NEEDSDELETE;
            }
            if (this.state == State.NEEDSDELETE && this.concurrentCount == 0) {
                callback.apply();
                this.state = State.DELETED;
            }
        }
    }

    public abstract void stream(OutputStream var1, Cache.StreamProvider var2);

    public abstract void streamTwo(OutputStream var1, OutputStream var2, Cache.TwoStreamProvider var3);

    public abstract void deleteWhenPossible();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doEnter(Callback streamCallback, CallbackWithBooleanReturn checkFilesCallback) {
        Object object = this.lock;
        synchronized (object) {
            boolean useCache = false;
            if (this.state == State.UNCACHED) {
                useCache = this.tryStreamCallback(streamCallback);
            } else if (this.state == State.CACHED) {
                boolean isFileStillValid = checkFilesCallback.apply();
                useCache = !isFileStillValid ? this.tryStreamCallback(streamCallback) : true;
            } else if (this.state == State.NEEDSDELETE) {
                useCache = true;
            }
            ++this.concurrentCount;
            return useCache;
        }
    }

    private boolean tryStreamCallback(Callback streamCallback) {
        try {
            streamCallback.apply();
            this.state = State.CACHED;
            return true;
        }
        catch (Exception e) {
            this.log.warn("Problem caching to disk, skipping cache for this entry", (Throwable)e);
            this.state = State.UNCACHED;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExit(Callback callback) {
        Object object = this.lock;
        synchronized (object) {
            --this.concurrentCount;
            if (this.state == State.NEEDSDELETE && this.concurrentCount == 0) {
                callback.apply();
                this.state = State.DELETED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void streamFromFile(File file, OutputStream out) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            block4: {
                try {
                    if (e.getClass().getName().equals(CLIENT_ABORT_EXCEPTION)) break block4;
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    protected OutputStream createWriteStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    protected static interface CallbackWithBooleanReturn {
        public boolean apply();
    }

    protected static interface Callback {
        public void apply();
    }

    static enum State {
        UNCACHED,
        CACHED,
        NEEDSDELETE,
        DELETED;

    }
}

