/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractWebResourceFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class CssWebResource
extends AbstractWebResourceFormatter {
    private final boolean isAmdEnabled;
    private static final List<String> HANDLED_PARAMETERS = Arrays.asList("title", "media", "charset", "data-wrm-key", "data-wrm-batch-type");

    @Deprecated
    public CssWebResource() {
        this(false);
    }

    public CssWebResource(boolean isAmdEnabled) {
        this.isAmdEnabled = isAmdEnabled;
    }

    @Override
    public boolean matches(String name) {
        return name != null && (name.endsWith(".css") || this.isAmdEnabled && name.endsWith(".less"));
    }

    @Override
    public String formatResource(String url, Map<String, String> attributes) {
        if (!this.isValid(attributes)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"");
        buffer.append(StringEscapeUtils.escapeHtml4((String)url)).append("\"");
        List<String> attributeTokens = this.getParametersAsAttributes(attributes);
        if (attributes != null && attributes.size() > 0) {
            buffer.append(" ").append(StringUtils.join(attributeTokens.iterator(), (String)" "));
        }
        if (!attributes.containsKey("media")) {
            buffer.append(" media=\"all\"");
        }
        buffer.append(">\n");
        return buffer.toString();
    }

    @Override
    protected List<String> getAttributeParameters() {
        return HANDLED_PARAMETERS;
    }
}

