/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.helpers;

import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class BaseHelpers {
    protected static final Predicate<Bundle> ALWAYS_FAILING_DEEP_FILTER = Predicates.alwaysFalse();

    public static Predicate<Bundle> isConditionsSatisfied(final RequestCache requestCache, final Map<String, String> params) {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                CachedCondition condition = bundle.getCondition();
                return condition == null || condition.evaluateSafely(requestCache, params);
            }
        };
    }

    public static Predicate<Bundle> isConditionsSatisfied(final RequestCache requestCache, final UrlBuildingStrategy urlBuilderStrategy) {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                CachedCondition condition = bundle.getCondition();
                return condition == null || condition.evaluateSafely(requestCache, urlBuilderStrategy);
            }
        };
    }

    public static Predicate<Bundle> hasLegacyCondition() {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                return bundle.hasLegacyConditions();
            }
        };
    }

    public static Predicate<Bundle> hasConditions() {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                return bundle.getCondition() != null;
            }
        };
    }

    public static BundleFinder find(Snapshot snapshot) {
        return new BundleFinder(snapshot);
    }

    protected static Found find(Snapshot snapshot, Collection<String> included, Set<String> excluded, Predicate<Bundle> conditionsForExcluded, boolean resolveExcluded, Predicate<Bundle> deep, Predicate<Bundle> deepFilter, Predicate<Bundle> shallowFilter, PredicateFailStrategy deepFilterFailStrategy) {
        if (included.isEmpty()) {
            return new Found(new ArrayList<Found.Item>());
        }
        Set<String> excludedResolved = resolveExcluded ? new HashSet<String>(BaseHelpers.find(snapshot, excluded, new LinkedHashSet<String>(), conditionsForExcluded, false, (Predicate<Bundle>)Predicates.alwaysTrue(), conditionsForExcluded, (Predicate<Bundle>)Predicates.alwaysTrue(), deepFilterFailStrategy).getFound()) : excluded;
        LinkedHashMap<String, Found.Item.State> discovered = new LinkedHashMap<String, Found.Item.State>();
        ArrayList<Found.Item> resolved = new ArrayList<Found.Item>();
        for (String key : included) {
            BaseHelpers.findItChangesArguments(snapshot, key, excludedResolved, new LinkedHashSet<String>(), deep, deepFilter, shallowFilter, discovered, resolved, deepFilterFailStrategy);
        }
        return new Found(resolved);
    }

    protected static void findItChangesArguments(Snapshot snapshot, String key, Set<String> excluded, LinkedHashSet<String> stack, Predicate<Bundle> deep, Predicate<Bundle> deepFilter, Predicate<Bundle> shallowFilter, Map<String, Found.Item.State> discovered, List<Found.Item> resolved, PredicateFailStrategy deepFilterFailStrategy) {
        BaseHelpers.findItChangesArguments(snapshot, key, excluded, stack, deep, deepFilter, shallowFilter, discovered, resolved, EnumSet.noneOf(TraversalOption.class), deepFilterFailStrategy);
    }

    private static void findItChangesArguments(Snapshot snapshot, String key, Set<String> excluded, LinkedHashSet<String> stack, Predicate<Bundle> deep, Predicate<Bundle> deepFilter, Predicate<Bundle> shallowFilter, Map<String, Found.Item.State> discovered, List<Found.Item> resolved, EnumSet<TraversalOption> traversalOptions, PredicateFailStrategy deepFilterFailStrategy) {
        if (discovered.containsKey(key)) {
            Found.Item.State state = discovered.get(key);
            boolean disableBundleContribution = traversalOptions.contains((Object)TraversalOption.RECORD_FAILED);
            if (disableBundleContribution && !Found.Item.State.INCLUDED.equals((Object)state) || !disableBundleContribution && Found.Item.State.INCLUDED.equals((Object)state)) {
                return;
            }
        }
        if (excluded.contains(key)) {
            if (deepFilterFailStrategy == PredicateFailStrategy.CONTINUE) {
                EnumSet<TraversalOption> newOptions = EnumSet.copyOf(traversalOptions);
                newOptions.add(TraversalOption.RECORD_FAILED);
                Bundle bundle = snapshot.get(key);
                stack.add(key);
                BaseHelpers.advanceDeeperIfAllowed(snapshot, excluded, stack, deep, ALWAYS_FAILING_DEEP_FILTER, shallowFilter, discovered, resolved, bundle, newOptions, deepFilterFailStrategy);
                BaseHelpers.recordDiscoveredItem(discovered, resolved, key, Found.Item.State.IGNORED);
                stack.remove(key);
            }
            return;
        }
        if (stack.contains(key)) {
            Support.LOGGER.warn("cyclic plugin resource dependency has been detected with: {}, stack trace: {}", (Object)key, stack);
            return;
        }
        stack.add(key);
        Bundle bundle = snapshot.get(key);
        if (bundle != null) {
            if (deepFilter.apply((Object)bundle)) {
                BaseHelpers.advanceDeeperIfAllowed(snapshot, excluded, stack, deep, deepFilter, shallowFilter, discovered, resolved, bundle, traversalOptions, deepFilterFailStrategy);
                if (shallowFilter.apply((Object)bundle)) {
                    BaseHelpers.recordDiscoveredItem(discovered, resolved, key, Found.Item.State.INCLUDED);
                } else {
                    BaseHelpers.recordDiscoveredItem(discovered, resolved, key, Found.Item.State.SKIPPED);
                }
            } else {
                if (deepFilterFailStrategy == PredicateFailStrategy.CONTINUE) {
                    EnumSet<TraversalOption> newOptions = EnumSet.copyOf(traversalOptions);
                    newOptions.add(TraversalOption.RECORD_FAILED);
                    BaseHelpers.advanceDeeperIfAllowed(snapshot, excluded, stack, deep, ALWAYS_FAILING_DEEP_FILTER, shallowFilter, discovered, resolved, bundle, newOptions, deepFilterFailStrategy);
                }
                Found.Item.State state = traversalOptions.contains((Object)TraversalOption.RECORD_FAILED) ? Found.Item.State.IGNORED : Found.Item.State.SKIPPED;
                BaseHelpers.recordDiscoveredItem(discovered, resolved, key, state);
            }
        } else if (Config.isContextKey(key)) {
            BaseHelpers.findItChangesArguments(snapshot, Config.virtualContextKeyToWebResourceKey(key), excluded, stack, deep, deepFilter, shallowFilter, discovered, resolved, traversalOptions, deepFilterFailStrategy);
        }
        stack.remove(key);
    }

    private static void recordDiscoveredItem(Map<String, Found.Item.State> discovered, List<Found.Item> resolved, String item, Found.Item.State state) {
        if (discovered.containsKey(item) && !Found.Item.State.INCLUDED.equals((Object)state)) {
            return;
        }
        discovered.put(item, state);
        resolved.add(new Found.Item(item, state));
    }

    private static void advanceDeeperIfAllowed(Snapshot snapshot, Set<String> excluded, LinkedHashSet<String> stack, Predicate<Bundle> deep, Predicate<Bundle> deepFilter, Predicate<Bundle> shallowFilter, Map<String, Found.Item.State> discovered, List<Found.Item> resolved, Bundle bundle, EnumSet<TraversalOption> traversalOptions, PredicateFailStrategy deepFilterFailStrategy) {
        if (deep.apply((Object)bundle)) {
            List<String> bundleDependencies = bundle.getDependencies();
            for (String dependencyKey : bundleDependencies) {
                BaseHelpers.findItChangesArguments(snapshot, dependencyKey, excluded, stack, deep, deepFilter, shallowFilter, discovered, resolved, traversalOptions, deepFilterFailStrategy);
            }
        }
    }

    public static List<Resource> getResources(RequestCache requestCache, Collection<String> keys) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String key : keys) {
            Bundle bundle = requestCache.getSnapshot().get(key);
            if (bundle == null) continue;
            for (Resource resource : bundle.getResources(requestCache).values()) {
                resources.add(resource);
            }
        }
        return resources;
    }

    public static class Found {
        private final List<Item> items;

        public Found(List<Item> items) {
            this.items = items;
        }

        public List<String> getFound() {
            return this.items.stream().filter(item -> ((Item)item).getState() == Item.State.INCLUDED).map(Item::getKey).distinct().collect(Collectors.toList());
        }

        public List<String> getSkipped() {
            return this.items.stream().filter(item -> ((Item)item).getState() == Item.State.SKIPPED).map(Item::getKey).distinct().collect(Collectors.toList());
        }

        public List<String> getAll() {
            return this.items.stream().map(Item::getKey).distinct().collect(Collectors.toList());
        }

        public static class Item {
            private final String key;
            private final State state;

            private Item(@Nonnull String key, State state) {
                Objects.requireNonNull(key);
                this.key = key;
                this.state = state;
            }

            public String getKey() {
                return this.key;
            }

            private State getState() {
                return this.state;
            }

            private static enum State {
                INCLUDED,
                SKIPPED,
                IGNORED;

            }
        }
    }

    public static class ResourceFinder {
        private final BundleFinder bundleFinder;
        private final RequestCache requestCache;
        private Predicate<Resource> filter;

        public ResourceFinder(BundleFinder bundleFinder, RequestCache requestCache) {
            this.bundleFinder = bundleFinder;
            this.requestCache = requestCache;
        }

        public ResourceFinder filter(Predicate<Resource> filter) {
            this.filter = filter;
            return this;
        }

        public List<Resource> end() {
            List<String> keys = this.bundleFinder.end();
            List<Resource> resources = BaseHelpers.getResources(this.requestCache, keys);
            ArrayList<Resource> filtered = new ArrayList<Resource>();
            for (Resource resource : resources) {
                if (!this.filter.apply((Object)resource)) continue;
                filtered.add(resource);
            }
            return filtered;
        }
    }

    public static class BundleFinder {
        private Snapshot snapshot;
        private Collection<String> included = new ArrayList<String>();
        private Set<String> excluded = new HashSet<String>();
        private Predicate<Bundle> conditionsForExcluded;
        private boolean resolveExcluded = true;
        private Predicate<Bundle> deep = Predicates.alwaysTrue();
        private List<Predicate<Bundle>> deepFilters = new ArrayList<Predicate<Bundle>>();
        private List<Predicate<Bundle>> shallowFilters = new ArrayList<Predicate<Bundle>>();
        private PredicateFailStrategy deepFilterFailStrategy = PredicateFailStrategy.STOP;

        public BundleFinder(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public BundleFinder onDeepFilterFail(PredicateFailStrategy deepFilterFailStrategy) {
            this.deepFilterFailStrategy = deepFilterFailStrategy;
            return this;
        }

        public BundleFinder included(Collection<String> included) {
            this.included = included;
            return this;
        }

        public BundleFinder included(String key) {
            this.included = new ArrayList<String>();
            this.included.add(key);
            return this;
        }

        public BundleFinder excluded(Set<String> excluded, Predicate<Bundle> conditionsForExcluded) {
            this.excluded = excluded;
            this.conditionsForExcluded = conditionsForExcluded;
            this.resolveExcluded = true;
            return this;
        }

        public BundleFinder excludedResolved(Set<String> excluded) {
            this.excluded = excluded;
            this.conditionsForExcluded = Predicates.alwaysTrue();
            this.resolveExcluded = false;
            return this;
        }

        public BundleFinder deep(boolean deep) {
            return this.deep((Predicate<Bundle>)(deep ? Predicates.alwaysTrue() : Predicates.alwaysFalse()));
        }

        public BundleFinder deep(Predicate<Bundle> deep) {
            this.deep = deep;
            return this;
        }

        public BundleFinder deepFilter(Predicate<Bundle> filter) {
            this.deepFilters.add(filter);
            return this;
        }

        public BundleFinder shallowFilter(Predicate<Bundle> filter) {
            this.shallowFilters.add(filter);
            return this;
        }

        public Found endAndGetResult() {
            Predicate<Bundle> conditionsForExcluded = this.conditionsForExcluded == null ? Predicates.alwaysTrue() : this.conditionsForExcluded;
            return BaseHelpers.find(this.snapshot, this.included, this.excluded, conditionsForExcluded, this.resolveExcluded, this.deep, Support.efficientAndPredicate(this.deepFilters), Support.efficientAndPredicate(this.shallowFilters), this.deepFilterFailStrategy);
        }

        public List<String> end() {
            return this.endAndGetResult().getFound();
        }

        public ResourceFinder resources(RequestCache requestCache) {
            return new ResourceFinder(this, requestCache);
        }
    }

    public static enum TraversalOption {
        RECORD_FAILED;

    }

    public static enum PredicateFailStrategy {
        STOP,
        CONTINUE;

    }
}

