/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.querydsl;

import com.atlassian.annotations.PublicApi;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

@PublicApi
public class Connections {
    private static final Logger log = Logger.getLogger(Connections.class);

    public static void close(Connection connection) {
        try {
            if (connection != null) {
                log.debug((Object)"Closing connection...");
                connection.close();
                log.debug((Object)"Closed connection");
            }
        }
        catch (SQLException e) {
            log.warn((Object)("Unable to close SQL connection " + e.getMessage()));
        }
    }

    public static void close(Statement statement) {
        try {
            if (statement != null) {
                log.debug((Object)"Closing statement...");
                statement.close();
                log.debug((Object)"Closed statement");
            }
        }
        catch (SQLException e) {
            log.warn((Object)("Unable to close SQL statement " + e.getMessage()));
        }
    }

    public static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                log.debug((Object)"Closing result set...");
                resultSet.close();
                log.debug((Object)"Closed result set");
            }
        }
        catch (SQLException e) {
            log.warn((Object)("Unable to close SQL result set " + e.getMessage()));
        }
    }
}

