/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.querydsl;

import com.atlassian.annotations.PublicApi;
import com.mysema.commons.lang.Pair;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLListener;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.dml.SQLInsertBatch;
import com.mysema.query.sql.dml.SQLMergeBatch;
import com.mysema.query.sql.dml.SQLUpdateBatch;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class LoggingSqlListener
implements SQLListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingSqlListener.class);
    private final Configuration configuration;

    public LoggingSqlListener(Configuration configuration) {
        this.configuration = configuration;
    }

    public void notifyQuery(QueryMetadata md) {
        if (this.weShouldLog()) {
            this.log(this.getSelectSql(md));
        }
    }

    public void notifyDelete(RelationalPath<?> entity, QueryMetadata md) {
        if (this.weShouldLog()) {
            this.log(this.getDeleteSql(entity, md));
        }
    }

    public void notifyDeletes(RelationalPath<?> entity, List<QueryMetadata> batches) {
        if (this.weShouldLog()) {
            this.log(this.getBatchDeleteSql(entity, batches));
        }
    }

    public void notifyMerge(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> keys, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        if (this.weShouldLog()) {
            this.log(this.getMergeSql(entity, md, keys, columns, values, subQuery));
        }
    }

    public void notifyMerges(RelationalPath<?> entity, QueryMetadata md, List<SQLMergeBatch> batches) {
        if (this.weShouldLog()) {
            this.log(this.getBatchMergeSql(entity, md, batches));
        }
    }

    public void notifyInsert(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        if (this.weShouldLog()) {
            this.log(this.getInsertSql(entity, md, columns, values, subQuery));
        }
    }

    public void notifyInserts(RelationalPath<?> entity, QueryMetadata md, List<SQLInsertBatch> batches) {
        if (this.weShouldLog()) {
            this.log(this.getBatchInsertSql(entity, md, batches));
        }
    }

    public void notifyUpdate(RelationalPath<?> entity, QueryMetadata md, List<Pair<Path<?>, Expression<?>>> updates) {
        if (this.weShouldLog()) {
            this.log(this.getUpdateSql(entity, md, updates));
        }
    }

    public void notifyUpdates(RelationalPath<?> entity, List<SQLUpdateBatch> batches) {
        if (this.weShouldLog()) {
            this.log(this.getBatchUpdateSql(entity, batches));
        }
    }

    private boolean weShouldLog() {
        return log.isDebugEnabled();
    }

    private void log(String sql) {
        if (StringUtils.isNotBlank((String)sql)) {
            log.debug(sql);
        }
    }

    private String getSelectSql(QueryMetadata queryMetadata) {
        SQLSerializer serializer = this.newLiteralPrintingSerializer();
        serializer.serialize(queryMetadata, false);
        return serializer.toString();
    }

    private String getDeleteSql(RelationalPath<?> entity, QueryMetadata queryMetadata) {
        SQLSerializer serializer = this.newLiteralPrintingSerializer();
        serializer.serializeDelete(queryMetadata, entity);
        return serializer.toString();
    }

    private String getBatchDeleteSql(RelationalPath<?> entity, List<QueryMetadata> deleteQueriesMetadata) {
        StringBuilder batchDeleteQueries = new StringBuilder();
        batchDeleteQueries.append("<Start batch delete> ");
        for (QueryMetadata queryMetadata : deleteQueriesMetadata) {
            batchDeleteQueries.append(this.getDeleteSql(entity, queryMetadata));
            batchDeleteQueries.append("; ");
        }
        batchDeleteQueries.append(" <End batch delete>");
        return batchDeleteQueries.toString();
    }

    private String getMergeSql(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> keys, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        SQLSerializer serializer = this.newLiteralPrintingSerializer();
        serializer.serializeMerge(md, entity, keys, columns, values, subQuery);
        return serializer.toString();
    }

    private String getBatchMergeSql(RelationalPath<?> entity, QueryMetadata md, List<SQLMergeBatch> mergeBatches) {
        StringBuilder batchMergeQueries = new StringBuilder();
        batchMergeQueries.append("<Start batch merge> ");
        for (SQLMergeBatch mergeBatch : mergeBatches) {
            batchMergeQueries.append(this.getMergeSql(entity, md, mergeBatch.getKeys(), mergeBatch.getColumns(), mergeBatch.getValues(), mergeBatch.getSubQuery()));
            batchMergeQueries.append("; ");
        }
        batchMergeQueries.append(" <End batch merge>");
        return batchMergeQueries.toString();
    }

    private String getInsertSql(RelationalPath<?> entity, QueryMetadata md, List<Path<?>> columns, List<Expression<?>> values, SubQueryExpression<?> subQuery) {
        SQLSerializer serializer = this.newLiteralPrintingSerializer();
        serializer.serializeInsert(md, entity, columns, values, subQuery);
        return serializer.toString();
    }

    private String getBatchInsertSql(RelationalPath<?> entity, QueryMetadata md, List<SQLInsertBatch> insertBatches) {
        StringBuilder batchInsertQueries = new StringBuilder();
        batchInsertQueries.append("<Start batch insert> ");
        for (SQLInsertBatch insertBatch : insertBatches) {
            batchInsertQueries.append(this.getInsertSql(entity, md, insertBatch.getColumns(), insertBatch.getValues(), insertBatch.getSubQuery()));
            batchInsertQueries.append("; ");
        }
        batchInsertQueries.append(" <End batch insert>");
        return batchInsertQueries.toString();
    }

    private String getUpdateSql(RelationalPath<?> entity, QueryMetadata md, List<Pair<Path<?>, Expression<?>>> updates) {
        SQLSerializer serializer = this.newLiteralPrintingSerializer();
        serializer.serializeUpdate(md, entity, updates);
        return serializer.toString();
    }

    private String getBatchUpdateSql(RelationalPath<?> entity, List<SQLUpdateBatch> updateBatches) {
        StringBuilder batchUpdateQueries = new StringBuilder();
        batchUpdateQueries.append("<Start batch update> ");
        for (SQLUpdateBatch updateBatch : updateBatches) {
            batchUpdateQueries.append(this.getUpdateSql(entity, updateBatch.getMetadata(), updateBatch.getUpdates()));
            batchUpdateQueries.append("; ");
        }
        batchUpdateQueries.append(" <End batch update>");
        return batchUpdateQueries.toString();
    }

    private SQLSerializer newLiteralPrintingSerializer() {
        SQLSerializer literalPrintingSerializer = new SQLSerializer(this.configuration);
        literalPrintingSerializer.setUseLiterals(true);
        return literalPrintingSerializer;
    }
}

