/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.querydsl;

import com.atlassian.annotations.Internal;
import com.google.common.base.Function;
import com.mysema.query.Tuple;
import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.NumberExpression;
import java.math.BigDecimal;

@Internal
class TupleMapper {
    TupleMapper() {
    }

    <T> Function<Tuple, T> column(final Expression<T> expr) {
        return new Function<Tuple, T>(){

            public T apply(Tuple tuple) {
                Object t = tuple.get(expr);
                return t == null ? null : t;
            }
        };
    }

    <T extends Number> Function<Tuple, Integer> toInt(final NumberExpression<T> expr) {
        return new Function<Tuple, Integer>(){

            public Integer apply(Tuple tuple) {
                Number t = (Number)tuple.get((Expression)expr);
                return t == null ? null : Integer.valueOf(t.intValue());
            }
        };
    }

    <T extends Number> Function<Tuple, Long> toLong(final NumberExpression<T> expr) {
        return new Function<Tuple, Long>(){

            public Long apply(Tuple tuple) {
                Number t = (Number)tuple.get((Expression)expr);
                return t == null ? null : Long.valueOf(t.longValue());
            }
        };
    }

    <T extends Number> Function<Tuple, Float> toFloat(final NumberExpression<T> expr) {
        return new Function<Tuple, Float>(){

            public Float apply(Tuple tuple) {
                Number t = (Number)tuple.get((Expression)expr);
                return t == null ? null : Float.valueOf(t.floatValue());
            }
        };
    }

    <T extends Number> Function<Tuple, Double> toDouble(final NumberExpression<T> expr) {
        return new Function<Tuple, Double>(){

            public Double apply(Tuple tuple) {
                Number t = (Number)tuple.get((Expression)expr);
                return t == null ? null : Double.valueOf(t.doubleValue());
            }
        };
    }

    <T extends Number> Function<Tuple, BigDecimal> toBigDecimal(final NumberExpression<T> expr) {
        return new Function<Tuple, BigDecimal>(){

            public BigDecimal apply(Tuple tuple) {
                Number t = (Number)tuple.get((Expression)expr);
                if (t instanceof BigDecimal) {
                    return (BigDecimal)t;
                }
                return t == null ? null : new BigDecimal(t.doubleValue());
            }
        };
    }
}

