/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.api.querydsl.ClosePromise;
import com.atlassian.pocketknife.api.querydsl.CloseableIterable;
import com.atlassian.pocketknife.api.querydsl.StreamyResult;
import com.atlassian.pocketknife.api.querydsl.Tuples;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Tuple;
import com.mysema.query.types.Expression;

public class StreamyResultImpl
implements StreamyResult {
    private final CloseableIterator<Tuple> closeableIterator;
    private final ClosePromise closePromise;

    public StreamyResultImpl(final CloseableIterator<Tuple> closeableIterator, ClosePromise parentPromise) {
        this.closeableIterator = closeableIterator;
        this.closePromise = new ClosePromise(parentPromise, new Runnable(){

            @Override
            public void run() {
                closeableIterator.close();
            }
        });
    }

    private Function<Tuple, Tuple> identity() {
        return Functions.identity();
    }

    @Override
    public CloseableIterator<Tuple> iterator() {
        CloseableIterable<Tuple> iterable = this.map((Function<Tuple, D>)((Function)this.identity()));
        return iterable.iterator();
    }

    @Override
    public ClosePromise getClosePromise() {
        return this.closePromise;
    }

    @Override
    public <D> CloseableIterable<D> map(Function<Tuple, D> mapper) {
        if (this.closePromise.isClosed()) {
            throw new IllegalStateException("This streaming result has already been closed");
        }
        return Tuples.map(this.closeableIterator, mapper, this.closePromise);
    }

    public <D> CloseableIterable<D> map(Expression<D> expr) {
        return this.map(Tuples.column(expr));
    }

    @Override
    public CloseableIterable<Tuple> take(int n) {
        if (this.closePromise.isClosed()) {
            throw new IllegalStateException("This streaming result has already been closed");
        }
        return Tuples.take(this.closeableIterator, this.identity(), this.closePromise, n);
    }

    @Override
    public CloseableIterable<Tuple> takeWhile(Predicate<Tuple> takeWhilePredicate) {
        if (this.closePromise.isClosed()) {
            throw new IllegalStateException("This streaming result has already been closed");
        }
        return Tuples.takeWhile(this.closeableIterator, this.identity(), this.closePromise, takeWhilePredicate);
    }

    @Override
    public CloseableIterable<Tuple> filter(Predicate<Tuple> filterPredicate) {
        if (this.closePromise.isClosed()) {
            throw new IllegalStateException("This streaming result has already been closed");
        }
        return Tuples.filter(this.closeableIterator, this.identity(), this.closePromise, filterPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<Tuple> fetchFirst() {
        if (this.closePromise.isClosed()) {
            throw new IllegalStateException("This streaming result has already been closed");
        }
        try {
            CloseableIterator<Tuple> iterator = this.iterator();
            if (iterator.hasNext()) {
                Option option = Option.some((Object)iterator.next());
                return option;
            }
        }
        finally {
            this.closePromise.close();
        }
        return Option.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foreach(Effect<Tuple> effect) {
        if (this.closePromise.isClosed()) {
            throw new IllegalStateException("This streaming result has already been closed");
        }
        try {
            for (Tuple tuple : this) {
                effect.apply((Object)tuple);
            }
        }
        finally {
            this.closePromise.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T foldLeft(T initial, Function2<T, Tuple, T> combiningFunction) {
        if (this.closePromise.isClosed()) {
            throw new IllegalStateException("This streaming result has already been closed");
        }
        try {
            Object accumulator = initial;
            while (this.closeableIterator.hasNext()) {
                accumulator = combiningFunction.apply(accumulator, this.closeableIterator.next());
            }
            T t = accumulator;
            return t;
        }
        finally {
            this.closePromise.close();
        }
    }

    @Override
    public void close() {
        this.closePromise.close();
    }
}

