/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl;

import com.atlassian.pocketknife.api.querydsl.ConnectionProvider;
import com.atlassian.pocketknife.api.querydsl.TransactionalExecutor;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TransactionExecutorImpl
implements TransactionalExecutor {
    private static final Logger log = LoggerFactory.getLogger(TransactionExecutorImpl.class);
    private final ConnectionProvider connectionProvider;

    @Autowired
    public TransactionExecutorImpl(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public <T> T executeInTransaction(@Nonnull Function<Connection, T> toExecute) {
        Assertions.notNull((String)"Function to execute is required", toExecute);
        return this.connectionProvider.withConnection(InTransactionExecutor.withFunction(toExecute));
    }

    static class InTransactionExecutor<T>
    implements Function<Connection, T> {
        private Function<Connection, T> toExecute;

        private InTransactionExecutor(Function<Connection, T> toExecute) {
            Assertions.notNull((String)"toExecute is required", toExecute);
            this.toExecute = toExecute;
        }

        static <T> InTransactionExecutor<T> withFunction(Function<Connection, T> toExecute) {
            return new InTransactionExecutor<T>(toExecute);
        }

        public T apply(@Nullable Connection connection) {
            Object result;
            try {
                log.debug("Invoking function within database transaction");
                result = this.toExecute.apply((Object)connection);
            }
            catch (RuntimeException exceptionThrownFromFunction) {
                log.debug("Unable to invoke function within database transaction due to: {}", (Object)exceptionThrownFromFunction.getMessage());
                this.rollback(connection);
                throw exceptionThrownFromFunction;
            }
            this.commit(connection);
            return (T)result;
        }

        private void commit(Connection connection) {
            log.debug("Performing commit on connection");
            try {
                connection.commit();
            }
            catch (SQLException commitException) {
                throw new RuntimeException("Unable to commit", commitException);
            }
        }

        private void rollback(Connection connection) {
            log.debug("Performing rollback on connection");
            try {
                connection.rollback();
            }
            catch (SQLException rollbackException) {
                log.error("Unable to rollback connection due to: {}", (Object)rollbackException.getMessage());
            }
        }

        @VisibleForTesting
        Function<Connection, T> getFunctionToExecute() {
            return this.toExecute;
        }
    }
}

