/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.spi.querydsl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.pocketknife.api.querydsl.ConnectionProvider;
import com.google.common.base.Function;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class AbstractConnectionProvider
implements ConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectionProvider.class);

    protected abstract Connection getConnectionImpl(boolean var1);

    protected Logger log() {
        return log;
    }

    @Override
    public Connection borrowConnection() {
        this.log().debug("Borrowing connection without auto-commit");
        return this.getConnectionImpl(false);
    }

    @Override
    public Connection borrowAutoCommitConnection() {
        this.log().debug("Borrowing connection with auto-commit");
        return this.getConnectionImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withConnection(Function<Connection, T> callback) {
        Connection connection = this.borrowConnection();
        try {
            Object object = callback.apply((Object)connection);
            return (T)object;
        }
        finally {
            this.returnConnection(connection);
        }
    }

    @Override
    public void returnConnection(Connection connection) {
        if (connection != null) {
            try {
                this.log().debug("Returning borrowed connection");
                connection.close();
            }
            catch (SQLException e) {
                this.log().warn(String.format("Unexpected exception when returning borrowed connection %s ", e.getMessage()));
            }
        }
    }
}

