/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Replacer {
    private static final int BUFFER_PADDING = 64;
    private static final String[] EMPTY_ARRAY = new String[0];
    private final Pattern pattern;
    private final String replacement;
    private final String[] necessaryConstantParts;
    private final boolean replacementHasMetachars;

    public Replacer(Pattern pattern, String replacement) {
        this(pattern, replacement, EMPTY_ARRAY);
    }

    public Replacer(Pattern pattern, String replacement, String ... necessaryConstantParts) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.necessaryConstantParts = necessaryConstantParts;
        this.replacementHasMetachars = replacement.indexOf(92) != -1 || replacement.indexOf(36) != -1;
    }

    public String replaceAll(String str) {
        for (int i = 0; i < this.necessaryConstantParts.length; ++i) {
            if (str.indexOf(this.necessaryConstantParts[i]) != -1) continue;
            return str;
        }
        return this.replaceAllSkippingConstantsCheck(str);
    }

    @Deprecated
    public String replace(String str) {
        return this.replaceAllSkippingConstantsCheck(str);
    }

    public String replaceAllSkippingConstantsCheck(String str) {
        Matcher matcher = this.pattern.matcher(str);
        if (!matcher.find()) {
            return str;
        }
        if (this.replacementHasMetachars) {
            return this.replaceAllHeavy(str, matcher);
        }
        StringBuilder sb = new StringBuilder(str.length() + 64).append(str, 0, matcher.start()).append(this.replacement);
        int mark = matcher.end();
        while (matcher.find()) {
            sb.append(str, mark, matcher.start()).append(this.replacement);
            mark = matcher.end();
        }
        return sb.append(str, mark, str.length()).toString();
    }

    private String replaceAllHeavy(String str, Matcher matcher) {
        StringBuilder sb = new StringBuilder(str.length() + 64).append(str, 0, matcher.start());
        this.appendReplacementPattern(sb, matcher);
        int mark = matcher.end();
        while (matcher.find()) {
            sb.append(str, mark, matcher.start());
            this.appendReplacementPattern(sb, matcher);
            mark = matcher.end();
        }
        return sb.append(str, mark, str.length()).toString();
    }

    private void appendReplacementPattern(StringBuilder sb, Matcher matcher) {
        int len = this.replacement.length();
        int groupCount = matcher.groupCount();
        int cursor = 0;
        while (cursor < len) {
            int newGroup;
            int digit;
            char c;
            if ((c = this.replacement.charAt(cursor++)) == '\\') {
                sb.append(this.replacement.charAt(cursor++));
                continue;
            }
            if (c != '$') {
                sb.append(c);
                continue;
            }
            int group = this.replacement.charAt(cursor) - 48;
            if (group < 0 || group > 9) {
                throw new IllegalArgumentException("Bad group reference: $" + this.replacement.charAt(cursor));
            }
            while (++cursor < len && (digit = this.replacement.charAt(cursor) - 48) >= 0 && digit <= 9 && groupCount >= (newGroup = group * 10 + digit)) {
                group = newGroup;
            }
            String groupText = matcher.group(group);
            if (groupText == null) continue;
            sb.append(groupText);
        }
    }
}

