/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.core.impl;

import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.scheduler.status.RunOutcome;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;

public class MemoryRunDetailsDao
implements RunDetailsDao {
    private final Cache<JobId, JobRecord> store;

    public MemoryRunDetailsDao() {
        this(30);
    }

    public MemoryRunDetailsDao(int daysToKeepIdleHistory) {
        this.store = CacheBuilder.newBuilder().expireAfterWrite((long)daysToKeepIdleHistory, TimeUnit.DAYS).build();
    }

    @Override
    public RunDetails getLastRunForJob(JobId jobId) {
        JobRecord record = (JobRecord)this.store.getIfPresent((Object)jobId);
        return record != null ? record.lastRun : null;
    }

    @Override
    public RunDetails getLastSuccessfulRunForJob(JobId jobId) {
        JobRecord record = (JobRecord)this.store.getIfPresent((Object)jobId);
        return record != null ? record.lastRun : null;
    }

    @Override
    public void addRunDetails(JobId jobId, RunDetails runDetails) {
        JobRecord record = runDetails.getRunOutcome() == RunOutcome.SUCCESS ? new JobRecord(runDetails, runDetails) : new JobRecord(runDetails, this.getLastSuccessfulRunForJob(jobId));
        this.store.put((Object)jobId, (Object)record);
    }

    static class JobRecord {
        final RunDetails lastRun;
        final RunDetails lastSuccessfulRun;

        JobRecord(RunDetails lastRun, RunDetails lastSuccessfulRun) {
            this.lastRun = lastRun;
            this.lastSuccessfulRun = lastSuccessfulRun;
        }
    }
}

