/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.marshalling.api.MarshallingPair;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;
import com.atlassian.vcache.internal.core.metrics.MetricsRecorder;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import com.atlassian.vcache.internal.core.service.GuavaJvmCache;
import com.atlassian.vcache.internal.guava.GuavaDirectExternalCache;
import com.atlassian.vcache.internal.guava.GuavaStableReadExternalCache;
import com.atlassian.vcache.internal.guava.GuavaTransactionalExternalCache;
import com.atlassian.vcache.internal.guava.GuavaUtils;
import com.atlassian.vcache.internal.memcached.MemcachedDirectExternalCache;
import com.atlassian.vcache.internal.memcached.MemcachedStableReadExternalCache;
import com.atlassian.vcache.internal.memcached.MemcachedTransactionalExternalCache;
import com.atlassian.vcache.internal.memcached.MemcachedVCacheServiceSettings;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedVCacheService
extends AbstractVCacheService {
    private static final Logger log = LoggerFactory.getLogger(MemcachedVCacheService.class);
    private final MemcachedVCacheServiceSettings serviceSettings;

    public MemcachedVCacheService(MemcachedVCacheServiceSettings settings) {
        super(settings.getContextSupplier(), settings.getWorkContextContextSupplier(), settings.getDefaultsProvider(), settings.getCreationHandler(), settings.getMetricsCollector(), settings.getExternalCacheKeyGenerator(), settings.getBegunTransactionalActivityHandler(), settings.getLockTimeout());
        this.serviceSettings = Objects.requireNonNull(settings);
    }

    protected Logger log() {
        return log;
    }

    protected <K, V> JvmCache<K, V> createJvmCache(String name, JvmCacheSettings settings) {
        return new GuavaJvmCache(name, settings, this.lockTimeout);
    }

    protected <V> TransactionalExternalCache<V> createTransactionalExternalCache(String name, ExternalCacheSettings settings, MarshallingPair<V> valueMarshalling, boolean valueSerializable) {
        if (this.serviceSettings.getDontExternaliseCache().apply(name).booleanValue()) {
            log.trace("Cache {}: not being externalised", (Object)name);
            return new GuavaTransactionalExternalCache(name, GuavaUtils.buildDelegate((ExternalCacheSettings)settings), this.threadLocalContextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshalling), this.transactionControlManager, (MetricsRecorder)this.metricsCollector, this.lockTimeout);
        }
        return new MemcachedTransactionalExternalCache<V>(this.serviceSettings, this.threadLocalContextSupplier, this.externalCacheKeyGenerator, name, valueMarshalling, settings, this.transactionControlManager, (MetricsRecorder)this.metricsCollector);
    }

    protected <V> StableReadExternalCache<V> createStableReadExternalCache(String name, ExternalCacheSettings settings, MarshallingPair<V> valueMarshalling, boolean valueSerializable) {
        if (this.serviceSettings.getDontExternaliseCache().apply(name).booleanValue()) {
            log.trace("Cache {}: not being externalised", (Object)name);
            return new GuavaStableReadExternalCache(name, GuavaUtils.buildDelegate((ExternalCacheSettings)settings), this.threadLocalContextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshalling), (MetricsRecorder)this.metricsCollector, this.serviceSettings.getLockTimeout());
        }
        return new MemcachedStableReadExternalCache<V>(this.serviceSettings, this.threadLocalContextSupplier, this.externalCacheKeyGenerator, name, valueMarshalling, settings, (MetricsRecorder)this.metricsCollector);
    }

    protected <V> DirectExternalCache<V> createDirectExternalCache(String name, ExternalCacheSettings settings, MarshallingPair<V> valueMarshalling, boolean valueSerializable) {
        if (this.serviceSettings.getDontExternaliseCache().apply(name).booleanValue()) {
            log.trace("Cache {}: not being externalised", (Object)name);
            return new GuavaDirectExternalCache(name, GuavaUtils.buildDelegate((ExternalCacheSettings)settings), this.threadLocalContextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshalling), this.lockTimeout);
        }
        return new MemcachedDirectExternalCache<V>(this.serviceSettings, this.threadLocalContextSupplier, this.externalCacheKeyGenerator, name, valueMarshalling, settings);
    }
}

