/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.internal;

import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.jms.internal.AtomikosJmsMessageConsumerWrapper;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;

class AtomikosJmsTopicSubscriberWrapper
extends AtomikosJmsMessageConsumerWrapper
implements TopicSubscriber {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsTopicSubscriberWrapper.class);

    public AtomikosJmsTopicSubscriberWrapper(TopicSubscriber delegate, SessionHandleState state) {
        super((MessageConsumer)delegate, state);
    }

    private TopicSubscriber getDelegateTopicSubscriber() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getDelegateTopicSubscriber()...");
        }
        TopicSubscriber ret = (TopicSubscriber)this.getDelegate();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": getDelegateTopicSubscriber() returning " + ret);
        }
        return ret;
    }

    public boolean getNoLocal() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getNoLocal()...");
        }
        boolean ret = false;
        try {
            ret = this.getDelegateTopicSubscriber().getNoLocal();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": getNoLocal() returning " + ret);
        }
        return ret;
    }

    public Topic getTopic() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getTopic()...");
        }
        Topic ret = null;
        try {
            ret = this.getDelegateTopicSubscriber().getTopic();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": getTopic() returning " + ret);
        }
        return ret;
    }

    @Override
    public String toString() {
        return "atomikosJmsTopicSubscriberWrapper for " + this.getDelegate();
    }
}

