/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.pool;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.PoolExhaustedException;
import com.atomikos.datasource.pool.Reapable;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.pool.XPooledConnectionEventListener;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.imp.thread.InterruptedExceptionHelper;
import com.atomikos.icatch.imp.thread.TaskManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConnectionPool
implements XPooledConnectionEventListener {
    public static final int DEFAULT_MAINTENANCE_INTERVAL = 60;
    private List connections = new ArrayList();
    private ConnectionFactory connectionFactory;
    private ConnectionPoolProperties properties;
    private boolean destroyed;
    private PooledAlarmTimer maintenanceTimer;

    public ConnectionPool(ConnectionFactory connectionFactory, ConnectionPoolProperties properties) throws ConnectionPoolException {
        this.connectionFactory = connectionFactory;
        this.properties = properties;
        this.destroyed = false;
        this.init();
    }

    private void assertNotDestroyed() throws ConnectionPoolException {
        if (this.destroyed) {
            throw new ConnectionPoolException("Pool was already destroyed - you can no longer use it");
        }
    }

    private void init() throws ConnectionPoolException {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": initializing..."));
        }
        for (int i = 0; i < this.properties.getMinPoolSize(); ++i) {
            try {
                XPooledConnection xpc = this.connectionFactory.createPooledConnection();
                this.connections.add(xpc);
                xpc.registerXPooledConnectionEventListener(this);
                continue;
            }
            catch (Exception dbDown) {
                if (!Configuration.isDebugLoggingEnabled()) continue;
                Configuration.logDebug((String)(this + ": could not establish initial connection"), (Throwable)dbDown);
            }
        }
        int maintenanceInterval = this.properties.getMaintenanceInterval();
        if (maintenanceInterval <= 0) {
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)(this + ": using default maintenance interval..."));
            }
            maintenanceInterval = 60;
        }
        this.maintenanceTimer = new PooledAlarmTimer((long)(maintenanceInterval * 1000));
        this.maintenanceTimer.addAlarmTimerListener(new AlarmTimerListener(){

            public void alarm(AlarmTimer timer) {
                ConnectionPool.this.shrinkPool();
                ConnectionPool.this.reapPool();
            }
        });
        TaskManager.getInstance().executeTask((Runnable)this.maintenanceTimer);
    }

    private Reapable recycleConnectionIfPossible(HeuristicMessage hmsg) throws Exception {
        Reapable ret = null;
        for (int i = 0; i < this.totalSize(); ++i) {
            XPooledConnection xpc = (XPooledConnection)this.connections.get(i);
            if (!xpc.canBeRecycledForCallingThread()) continue;
            ret = xpc.createConnectionProxy(hmsg);
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)(this + ": recycling connection from pool..."));
            }
            return ret;
        }
        return ret;
    }

    public synchronized Reapable borrowConnection(HeuristicMessage hmsg) throws CreateConnectionException, PoolExhaustedException, ConnectionPoolException {
        long remainingTime = (long)this.properties.getBorrowConnectionTimeout() * 1000L;
        Reapable ret = null;
        while (ret == null) {
            this.assertNotDestroyed();
            if (remainingTime <= 0L) {
                throw new PoolExhaustedException("Cannot get a connection after waiting for " + this.properties.getBorrowConnectionTimeout() + " secs");
            }
            Reapable recycledConnection = null;
            try {
                recycledConnection = this.recycleConnectionIfPossible(hmsg);
            }
            catch (Exception e) {
                Configuration.logWarning((String)(this + ": error while trying to recycle"), (Throwable)e);
            }
            if (recycledConnection != null) {
                return recycledConnection;
            }
            if (this.availableSize() == 0 && this.totalSize() < this.properties.getMaxPoolSize()) {
                this.growPool();
            } else {
                if (this.totalSize() == this.properties.getMaxPoolSize() && Configuration.isDebugLoggingEnabled()) {
                    Configuration.logDebug((String)(this + ": pool reached max size: " + this.properties.getMaxPoolSize()));
                }
                if (Configuration.isDebugLoggingEnabled()) {
                    Configuration.logDebug((String)(this + ": current size: " + this.availableSize() + "/" + this.totalSize()));
                }
                remainingTime = this.waitForConnectionInPoolIfNecessary(remainingTime);
            }
            XPooledConnection xpc = null;
            Iterator it = this.connections.iterator();
            while (it.hasNext() && ret == null) {
                xpc = (XPooledConnection)it.next();
                if (!xpc.isAvailable()) continue;
                try {
                    ret = xpc.createConnectionProxy(hmsg);
                    if (!Configuration.isDebugLoggingEnabled()) continue;
                    Configuration.logDebug((String)(this + ": got connection from pool, new size: " + this.availableSize() + "/" + this.totalSize()));
                }
                catch (CreateConnectionException ex) {
                    String msg = this + ": error creating proxy of connection " + xpc;
                    Configuration.logWarning((String)msg, (Throwable)ex);
                    it.remove();
                    xpc.destroy();
                }
            }
            if (ret != null) continue;
            Configuration.logWarning((String)(this + ": no connection found - waiting a bit..."));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                InterruptedExceptionHelper.handleInterruptedException((InterruptedException)e);
            }
            remainingTime -= 1000L;
        }
        return ret;
    }

    private synchronized void growPool() throws CreateConnectionException {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": growing pool size to: " + (this.totalSize() + 1)));
        }
        XPooledConnection xpc = this.connectionFactory.createPooledConnection();
        this.connections.add(xpc);
        xpc.registerXPooledConnectionEventListener(this);
    }

    private synchronized void shrinkPool() {
        if (this.connections == null || this.properties.getMaxIdleTime() <= 0) {
            return;
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": trying to shrink pool"));
        }
        ArrayList<XPooledConnection> connectionsToRemove = new ArrayList<XPooledConnection>();
        int maxConnectionsToRemove = this.totalSize() - this.properties.getMinPoolSize();
        if (maxConnectionsToRemove > 0) {
            for (int i = 0; i < this.connections.size(); ++i) {
                XPooledConnection xpc = (XPooledConnection)this.connections.get(i);
                long lastRelease = xpc.getLastTimeReleased();
                long maxIdle = this.properties.getMaxIdleTime();
                long now = System.currentTimeMillis();
                if (Configuration.isDebugLoggingEnabled()) {
                    Configuration.logDebug((String)(this + ": connection idle for " + (now - lastRelease) + "ms"));
                }
                if (!xpc.isAvailable() || now - lastRelease < maxIdle * 1000L || connectionsToRemove.size() >= maxConnectionsToRemove) continue;
                if (Configuration.isDebugLoggingEnabled()) {
                    Configuration.logDebug((String)(this + ": connection idle for more than " + maxIdle + "s, closing it: " + xpc));
                }
                xpc.destroy();
                connectionsToRemove.add(xpc);
            }
        }
        this.connections.removeAll(connectionsToRemove);
    }

    private synchronized void reapPool() {
        long maxInUseTime = this.properties.getReapTimeout();
        if (this.connections == null || maxInUseTime <= 0L) {
            return;
        }
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": reaping old connections"));
        }
        for (XPooledConnection xpc : this.connections) {
            long lastTimeReleased = xpc.getLastTimeAcquired();
            boolean inUse = !xpc.isAvailable();
            long now = System.currentTimeMillis();
            if (!inUse || now - maxInUseTime * 1000L <= lastTimeReleased) continue;
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)(this + ": connection in use for more than " + maxInUseTime + "s, reaping it: " + xpc));
            }
            xpc.reap();
        }
    }

    public synchronized void destroy() {
        if (!this.destroyed) {
            Configuration.logWarning((String)(this + ": destroying pool..."));
            for (int i = 0; i < this.connections.size(); ++i) {
                XPooledConnection xpc = (XPooledConnection)this.connections.get(i);
                xpc.destroy();
            }
            this.connections = null;
            this.destroyed = true;
            this.maintenanceTimer.stop();
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)(this + ": pool destroyed."));
            }
        }
    }

    private synchronized long waitForConnectionInPoolIfNecessary(long remainingTime) throws PoolExhaustedException {
        while (this.availableSize() == 0) {
            long now;
            long before;
            block6: {
                if (this.properties.getBorrowConnectionTimeout() <= 0) {
                    throw new PoolExhaustedException("ConnectionPool: pool is empty and borrowConnectionTimeout is not set");
                }
                before = System.currentTimeMillis();
                try {
                    if (Configuration.isDebugLoggingEnabled()) {
                        Configuration.logDebug((String)(this + ": about to wait for connection during " + remainingTime + "ms..."));
                    }
                    this.wait(remainingTime);
                }
                catch (InterruptedException ex) {
                    InterruptedExceptionHelper.handleInterruptedException((InterruptedException)ex);
                    if (!Configuration.isDebugLoggingEnabled()) break block6;
                    Configuration.logDebug((String)(this + ": interrupted during wait"), (Throwable)ex);
                }
            }
            if (Configuration.isDebugLoggingEnabled()) {
                Configuration.logDebug((String)(this + ": done waiting."));
            }
            if ((remainingTime -= (now = System.currentTimeMillis()) - before) > 0L) continue;
            throw new PoolExhaustedException("Connection pool is still empty after waiting for " + this.properties.getBorrowConnectionTimeout() + " secs");
        }
        return remainingTime;
    }

    public synchronized int availableSize() {
        int ret = 0;
        if (!this.destroyed) {
            int count = 0;
            for (int i = 0; i < this.connections.size(); ++i) {
                XPooledConnection xpc = (XPooledConnection)this.connections.get(i);
                if (!xpc.isAvailable()) continue;
                ++count;
            }
            ret = count;
        }
        return ret;
    }

    public synchronized int totalSize() {
        if (this.destroyed) {
            return 0;
        }
        return this.connections.size();
    }

    public synchronized void onXPooledConnectionTerminated(XPooledConnection connection) {
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": connection " + connection + " became available, notifying potentially waiting threads"));
        }
        this.notify();
    }

    public String toString() {
        String name = "";
        if (this.properties != null) {
            name = this.properties.getUniqueResourceName();
        }
        return "atomikos connection pool '" + name + "'";
    }
}

