/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.util.SerializableObjectFactory;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class J2eeUserTransaction
implements UserTransaction,
Serializable,
Referenceable {
    private static final long serialVersionUID = -7656447860674832182L;
    private transient TransactionManager txmgr_;

    private void checkSetup() {
        this.txmgr_ = TransactionManagerImp.getTransactionManager();
        if (this.txmgr_ == null) {
            throw new RuntimeException("Transaction Service Not Running?");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.checkSetup();
        this.txmgr_.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, IllegalStateException, SecurityException {
        this.checkSetup();
        this.txmgr_.commit();
    }

    public void rollback() throws IllegalStateException, SystemException, SecurityException {
        this.checkSetup();
        this.txmgr_.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkSetup();
        this.txmgr_.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        this.checkSetup();
        return this.txmgr_.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.checkSetup();
        this.txmgr_.setTransactionTimeout(seconds);
    }

    @Override
    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }
}

