/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.OrderedLifecycleComponent;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.jta.TransactionImp;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.util.SerializableObjectFactory;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class TransactionSynchronizationRegistryImp
implements TransactionSynchronizationRegistry,
Serializable,
Referenceable,
OrderedLifecycleComponent {
    private static final long serialVersionUID = 1L;
    private transient TransactionManager tm;

    private void assertTransactionManagerAvailable() {
        this.tm = TransactionManagerImp.getTransactionManager();
        if (this.tm == null) {
            throw new IllegalStateException("Transaction service not running");
        }
    }

    public Object getTransactionKey() {
        this.assertTransactionManagerAvailable();
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public void putResource(Object key, Object value) {
        this.assertTransactionManagerAvailable();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            TransactionImp tx = (TransactionImp)this.tm.getTransaction();
            if (tx == null) {
                this.throwNoTransactionFound();
            }
            tx.putResource(key, value);
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public Object getResource(Object key) {
        this.assertTransactionManagerAvailable();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            TransactionImp tx = (TransactionImp)this.tm.getTransaction();
            if (tx == null) {
                this.throwNoTransactionFound();
            }
            return tx.getResource(key);
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        this.assertTransactionManagerAvailable();
        try {
            TransactionImp tx = (TransactionImp)this.tm.getTransaction();
            if (tx == null) {
                this.throwNoTransactionFound();
            }
            tx.registerInterposedSynchronization(sync);
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    private void throwNoTransactionFound() {
        throw new IllegalStateException("No transaction found for calling thread");
    }

    public int getTransactionStatus() {
        this.assertTransactionManagerAvailable();
        try {
            return this.tm.getStatus();
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public void setRollbackOnly() {
        this.assertTransactionManagerAvailable();
        try {
            this.tm.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new SysException((Throwable)e);
        }
    }

    public boolean getRollbackOnly() {
        this.assertTransactionManagerAvailable();
        if (this.getTransactionStatus() == 6) {
            this.throwNoTransactionFound();
        }
        return false;
    }

    @Override
    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public void init() throws Exception {
    }

    public void close() throws Exception {
    }
}

