/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.imp.PropagationException;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.Result;

abstract class PropagationMessage {
    public static final int MAX_RETRIES = 5;
    protected Participant participant_;
    protected int retrycount_ = 0;
    protected Result result_ = null;

    public PropagationMessage(Participant participant, Result result) {
        this.participant_ = participant;
        this.result_ = result;
    }

    public Participant getParticipant() {
        return this.participant_;
    }

    protected abstract Object send() throws PropagationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean submit() {
        boolean failed = false;
        boolean transienterr = false;
        Exception exception = null;
        Object result = null;
        boolean retried = false;
        boolean heurcommit = false;
        try {
            result = this.send();
            return (boolean)result;
        }
        catch (PropagationException e) {
            failed = true;
            transienterr = e.isTransient();
            exception = e.getDetail();
            if (exception instanceof HeurCommitException) {
                heurcommit = true;
                return heurcommit;
            }
        }
        finally {
            if (failed && transienterr && this.retrycount_ < 5) {
                retried = true;
                ++this.retrycount_;
            }
            if (this.result_ != null) {
                this.result_.addReply(new Reply(result, exception, this.getParticipant(), retried));
            }
            return retried;
        }
    }
}

