/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.tcc.rest;

import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.tcc.rest.ParticipantAdapter;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.tcc.rest.ParticipantLink;
import java.util.Calendar;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;

public class ParticipantAdapterImp
implements ParticipantAdapter {
    private static final long serialVersionUID = 1L;
    private static Logger LOGGER = LoggerFactory.createLogger(ParticipantAdapterImp.class);
    private transient WebTarget part;
    private String uri;
    private long expires;

    public static WebTarget createJaxRsClientForUri(String uri) {
        Client client = ClientBuilder.newClient();
        client.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        return client.target(uri);
    }

    public static void callConfirmOnJaxrsClient(WebTarget target) throws HeurRollbackException {
        try {
            Response r = target.request(new String[]{"application/tcc"}).header("Content-type", (Object)"application/tcc").method("PUT");
            if (r.getStatus() == 404) {
                throw new HeurRollbackException();
            }
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == 404) {
                throw new HeurRollbackException();
            }
            throw e;
        }
    }

    public ParticipantAdapterImp(ParticipantLink pl) {
        this.uri = pl.getUri();
        Calendar cal = DatatypeConverter.parseDateTime((String)pl.getExpires());
        this.expires = cal.getTimeInMillis();
    }

    WebTarget getParticipant() {
        if (this.part == null) {
            this.part = ParticipantAdapterImp.createJaxRsClientForUri(this.uri);
        }
        return this.part;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void delete() {
        WebTarget p = this.getParticipant();
        try {
            p.request(new String[]{"application/tcc"}).header("Content-type", (Object)"application/tcc").delete();
        }
        catch (Exception ignore) {
            LOGGER.logTrace("Error invoking cancel on participant", (Throwable)ignore);
        }
    }

    @Override
    public void put() throws HeurRollbackException {
        WebTarget p = this.getParticipant();
        ParticipantAdapterImp.callConfirmOnJaxrsClient(p);
    }

    @Override
    public void options() {
        WebTarget p = this.getParticipant();
        try {
            p.request().options();
        }
        catch (Exception e) {
            LOGGER.logTrace("Error retrieving options", (Throwable)e);
        }
    }

    @Override
    public long getExpires() {
        return this.expires;
    }
}

