/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;

class SynchToFSM
implements FSMEnterListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(SynchToFSM.class);
    private Synchronization synch_;
    private boolean aftercompletion_;
    private boolean termination_;

    SynchToFSM(Synchronization s) {
        this.synch_ = s;
        this.aftercompletion_ = false;
        this.termination_ = false;
    }

    private void doAfterCompletion(TxState state) {
        try {
            this.synch_.afterCompletion((Object)state);
        }
        catch (RuntimeException e) {
            LOGGER.logWarning("Error during afterCompletion", (Throwable)e);
        }
    }

    public void entered(FSMEnterEvent e) {
        if (e != null) {
            if (e.getState().equals(TxState.COMMITTING) && !this.aftercompletion_) {
                this.doAfterCompletion(TxState.COMMITTING);
                this.aftercompletion_ = true;
            } else if (e.getState().equals(TxState.ABORTING) && !this.aftercompletion_) {
                this.doAfterCompletion(TxState.ABORTING);
                this.aftercompletion_ = true;
            } else if (e.getState().equals(TxState.TERMINATED) && !this.termination_) {
                this.doAfterCompletion(TxState.TERMINATED);
                this.aftercompletion_ = true;
                this.termination_ = true;
            } else if (e.getState().equals(TxState.HEUR_MIXED) && !this.termination_) {
                this.doAfterCompletion(TxState.HEUR_MIXED);
                this.termination_ = true;
            } else if (e.getState().equals(TxState.HEUR_ABORTED) && !this.termination_) {
                this.doAfterCompletion(TxState.HEUR_ABORTED);
                this.termination_ = true;
            } else if (e.getState().equals(TxState.HEUR_HAZARD) && !this.termination_) {
                this.doAfterCompletion(TxState.HEUR_HAZARD);
                this.termination_ = true;
            } else if (e.getState().equals(TxState.HEUR_COMMITTED) && !this.termination_) {
                this.doAfterCompletion(TxState.HEUR_COMMITTED);
                this.termination_ = true;
            }
        }
    }
}

