/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.ReportStatusStats;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.mediastorage.LocalMediaStorageHandler;
import com.aventstack.extentreports.mediastorage.MediaStorage;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.Device;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.context.ExceptionTestContextStore;
import com.aventstack.extentreports.model.context.SystemAttributeContext;
import com.aventstack.extentreports.model.context.TestAttributeTestContextStore;
import com.aventstack.extentreports.reporter.ExtentReporter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public abstract class AbstractReporter
implements ExtentReporter {
    private Date startTime;
    private Date endTime;
    private AnalysisStrategy strategy;
    private MediaStorage media;
    private List<Test> testList;
    private List<String> testRunnerLogs;
    private ExceptionTestContextStore exceptionContext;
    private TestAttributeTestContextStore<Category> categoryContext;
    private TestAttributeTestContextStore<Author> authorContext;
    private TestAttributeTestContextStore<Device> deviceContext;
    private SystemAttributeContext systemAttributeContext;
    private ReportStatusStats stats;
    private Collection<Status> statusCollection;

    public AbstractReporter() {
        this.endTime = this.startTime = Calendar.getInstance().getTime();
        this.strategy = AnalysisStrategy.TEST;
    }

    @Override
    public void flush(ReportAggregates reportAggregates) {
        this.startTime = reportAggregates.getStartTime();
        this.endTime = reportAggregates.getEndTime();
        this.authorContext = reportAggregates.getAuthorContext();
        this.categoryContext = reportAggregates.getCategoryContext();
        this.deviceContext = reportAggregates.getDeviceContext();
        this.exceptionContext = reportAggregates.getExceptionContext();
        this.stats = reportAggregates.getReportStatusStats();
        this.systemAttributeContext = reportAggregates.getSystemAttributeContext();
        this.testList = reportAggregates.getTestList();
        this.testRunnerLogs = reportAggregates.getTestRunnerLogs();
        this.statusCollection = reportAggregates.getStatusCollection();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setAnalysisStrategy(AnalysisStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public AnalysisStrategy getAnalysisStrategy() {
        return this.strategy;
    }

    public long getRunDuration() {
        return this.endTime.getTime() - this.startTime.getTime();
    }

    public String getLongRunDuration() {
        long millis = this.getRunDuration();
        long secs = millis / 1000L;
        long ms = millis % 1000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        return String.valueOf(hours) + "h " + (mins %= 60L) + "m " + (secs %= 60L) + "s+" + ms + "ms";
    }

    public List<Test> getTestList() {
        return this.testList;
    }

    public List<String> getTestRunnerLogs() {
        return this.testRunnerLogs;
    }

    public TestAttributeTestContextStore<Category> getCategoryContextInfo() {
        return this.categoryContext;
    }

    public TestAttributeTestContextStore<Author> getAuthorContextInfo() {
        return this.authorContext;
    }

    public TestAttributeTestContextStore<Device> getDeviceContextInfo() {
        return this.deviceContext;
    }

    public ExceptionTestContextStore getExceptionContextInfo() {
        return this.exceptionContext;
    }

    public SystemAttributeContext getSystemAttributeContext() {
        return this.systemAttributeContext;
    }

    public ReportStatusStats getReportStatusStats() {
        return this.stats;
    }

    public Collection<Status> getStatusCollection() {
        return this.statusCollection;
    }

    @Override
    public void onTestStarted(Test test) {
    }

    @Override
    public void onTestRemoved(Test test) {
    }

    @Override
    public void onNodeStarted(Test node) {
    }

    @Override
    public void onLogAdded(Test test, Log log) {
    }

    @Override
    public void onCategoryAssigned(Test test, Category category) {
    }

    @Override
    public void onAuthorAssigned(Test test, Author author) {
    }

    @Override
    public void onDeviceAssigned(Test test, Device device) {
    }

    @Override
    public void onScreenCaptureAdded(Test test, ScreenCapture screenCapture) throws IOException {
    }

    @Override
    public void onScreenCaptureAdded(Log log, ScreenCapture screenCapture) throws IOException {
    }

    protected void autoCreateRelativePathMedia(ScreenCapture screenCapture, Boolean autoCreateRelativePath, String destination) throws IOException {
        if (screenCapture.isBase64().booleanValue()) {
            return;
        }
        if (autoCreateRelativePath.booleanValue()) {
            if (this.media == null) {
                this.media = new LocalMediaStorageHandler();
                this.media.init(destination);
            }
            this.media.storeMedia(screenCapture);
        }
    }

    @Override
    public void stop() {
    }
}

