/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.markuputils;

import com.aventstack.extentreports.markuputils.ExtentColor;
import com.aventstack.extentreports.markuputils.Markup;
import lombok.Generated;

class Label
implements Markup {
    private static final long serialVersionUID = 548763908072445261L;
    private String text;
    private ExtentColor color;

    @Override
    public String getMarkup() {
        if (this.text == null || this.text.isEmpty()) {
            return "";
        }
        String textColor = this.color != ExtentColor.WHITE ? "white-text" : "black-text";
        String lhs = "<span class='badge " + textColor + " " + String.valueOf((Object)this.color).toLowerCase() + "'>";
        String rhs = "</span>";
        return lhs + this.text + rhs;
    }

    @Generated
    public static LabelBuilder builder() {
        return new LabelBuilder();
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public ExtentColor getColor() {
        return this.color;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setColor(ExtentColor color) {
        this.color = color;
    }

    @Generated
    public Label(String text, ExtentColor color) {
        this.text = text;
        this.color = color;
    }

    @Generated
    public String toString() {
        return "Label(text=" + this.getText() + ", color=" + (Object)((Object)this.getColor()) + ")";
    }

    public static class LabelBuilder {
        private String text = "";
        private ExtentColor color = ExtentColor.TRANSPARENT;

        @Generated
        LabelBuilder() {
        }

        @Generated
        public LabelBuilder text(String text) {
            this.text = text;
            return this;
        }

        @Generated
        public LabelBuilder color(ExtentColor color) {
            this.color = color;
            return this;
        }

        @Generated
        public Label build() {
            return new Label(this.text, this.color);
        }

        @Generated
        public String toString() {
            return "Label.LabelBuilder(text=" + this.text + ", color=" + (Object)((Object)this.color) + ")";
        }
    }
}

