/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.implementation.FormLineHelper;
import com.azure.ai.formrecognizer.implementation.FormPageHelper;
import com.azure.ai.formrecognizer.implementation.FormSelectionMarkHelper;
import com.azure.ai.formrecognizer.implementation.FormTableHelper;
import com.azure.ai.formrecognizer.implementation.RecognizedFormHelper;
import com.azure.ai.formrecognizer.implementation.TextAppearanceHelper;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeResult;
import com.azure.ai.formrecognizer.implementation.models.DocumentResult;
import com.azure.ai.formrecognizer.implementation.models.FieldValueSelectionMark;
import com.azure.ai.formrecognizer.implementation.models.FieldValueType;
import com.azure.ai.formrecognizer.implementation.models.KeyValuePair;
import com.azure.ai.formrecognizer.implementation.models.PageResult;
import com.azure.ai.formrecognizer.implementation.models.ReadResult;
import com.azure.ai.formrecognizer.implementation.models.SelectionMark;
import com.azure.ai.formrecognizer.implementation.models.TextLine;
import com.azure.ai.formrecognizer.implementation.models.TextWord;
import com.azure.ai.formrecognizer.models.FieldBoundingBox;
import com.azure.ai.formrecognizer.models.FieldData;
import com.azure.ai.formrecognizer.models.FieldValue;
import com.azure.ai.formrecognizer.models.FormElement;
import com.azure.ai.formrecognizer.models.FormField;
import com.azure.ai.formrecognizer.models.FormLine;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.FormPageRange;
import com.azure.ai.formrecognizer.models.FormSelectionMark;
import com.azure.ai.formrecognizer.models.FormTable;
import com.azure.ai.formrecognizer.models.FormTableCell;
import com.azure.ai.formrecognizer.models.FormWord;
import com.azure.ai.formrecognizer.models.LengthUnit;
import com.azure.ai.formrecognizer.models.Point;
import com.azure.ai.formrecognizer.models.RecognizedForm;
import com.azure.ai.formrecognizer.models.SelectionMarkState;
import com.azure.ai.formrecognizer.models.TextAppearance;
import com.azure.ai.formrecognizer.models.TextStyleName;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class Transforms {
    private static final ClientLogger LOGGER = new ClientLogger(Transforms.class);
    private static final String WORD_REGEX = "/readResults/(\\d+)/lines/(\\d+)/words/(\\d+)";
    private static final String LINE_REGEX = "/readResults/(\\d+)/lines/(\\d+)";
    private static final String SELECTION_MARK_REGEX = "/readResults/(\\d+)/selectionMarks/(\\d+)";
    private static final Pattern WORD_PATTERN = Pattern.compile("/readResults/(\\d+)/lines/(\\d+)/words/(\\d+)");
    private static final Pattern LINE_PATTERN = Pattern.compile("/readResults/(\\d+)/lines/(\\d+)");
    private static final Pattern SELECTION_MARK_PATTERN = Pattern.compile("/readResults/(\\d+)/selectionMarks/(\\d+)");
    private static final float DEFAULT_CONFIDENCE_VALUE = 1.0f;
    private static final int DEFAULT_TABLE_SPAN = 1;

    private Transforms() {
    }

    static List<RecognizedForm> toRecognizedForm(AnalyzeResult analyzeResult, boolean includeFieldElements, String modelId) {
        ArrayList<RecognizedForm> extractedFormList;
        List<ReadResult> readResults = analyzeResult.getReadResults();
        List<DocumentResult> documentResults = analyzeResult.getDocumentResults();
        List<PageResult> pageResults = analyzeResult.getPageResults();
        List<FormPage> formPages = Transforms.toRecognizedLayout(analyzeResult, includeFieldElements);
        if (!CoreUtils.isNullOrEmpty(documentResults)) {
            extractedFormList = new ArrayList<RecognizedForm>();
            for (DocumentResult documentResultItem : documentResults) {
                List<Integer> documentPageRange = documentResultItem.getPageRange();
                FormPageRange formPageRange = documentPageRange.size() == 2 ? new FormPageRange(documentPageRange.get(0), documentPageRange.get(1)) : new FormPageRange(1, 1);
                Map<String, FormField> extractedFieldMap = Transforms.getLabeledFieldMap(documentResultItem, readResults);
                RecognizedForm recognizedForm = new RecognizedForm(extractedFieldMap, documentResultItem.getDocType(), formPageRange, formPages.subList(formPageRange.getFirstPageNumber() - 1, formPageRange.getLastPageNumber()));
                RecognizedFormHelper.setFormTypeConfidence(recognizedForm, documentResultItem.getDocTypeConfidence());
                if (documentResultItem.getModelId() != null) {
                    RecognizedFormHelper.setModelId(recognizedForm, documentResultItem.getModelId().toString());
                }
                extractedFormList.add(recognizedForm);
            }
        } else {
            extractedFormList = new ArrayList();
            if (!CoreUtils.isNullOrEmpty(pageResults)) {
                Utility.forEachWithIndex(pageResults, (index, pageResultItem) -> {
                    StringBuilder formType = new StringBuilder("form-");
                    int pageNumber = pageResultItem.getPage();
                    Integer clusterId = pageResultItem.getClusterId();
                    if (clusterId != null) {
                        formType.append(clusterId);
                    }
                    Map<String, FormField> extractedFieldMap = Transforms.getUnlabeledFieldMap(includeFieldElements, readResults, pageResultItem, pageNumber);
                    RecognizedForm recognizedForm = new RecognizedForm(extractedFieldMap, formType.toString(), new FormPageRange(pageNumber, pageNumber), Collections.singletonList((FormPage)formPages.get((int)index)));
                    RecognizedFormHelper.setModelId(recognizedForm, modelId);
                    extractedFormList.add(recognizedForm);
                });
            }
        }
        return extractedFormList;
    }

    static List<FormPage> toRecognizedLayout(AnalyzeResult analyzeResult, boolean includeFieldElements) {
        List<ReadResult> readResults = analyzeResult.getReadResults();
        List<PageResult> pageResults = analyzeResult.getPageResults();
        ArrayList<FormPage> formPages = new ArrayList<FormPage>();
        boolean pageResultsIsNullOrEmpty = CoreUtils.isNullOrEmpty(pageResults);
        Utility.forEachWithIndex(readResults, (index, readResultItem) -> {
            PageResult pageResultItem;
            ArrayList<FormTable> perPageTableList = new ArrayList();
            if (!pageResultsIsNullOrEmpty && (pageResultItem = (PageResult)pageResults.get((int)index)) != null) {
                perPageTableList = Transforms.getPageTables(pageResultItem, readResults, pageResultItem.getPage());
            }
            ArrayList<FormLine> perPageFormLineList = new ArrayList();
            if (includeFieldElements && !CoreUtils.isNullOrEmpty(readResultItem.getLines())) {
                perPageFormLineList = Transforms.getReadResultFormLines(readResultItem);
            }
            List<FormSelectionMark> perPageFormSelectionMarkList = new ArrayList<FormSelectionMark>();
            if (includeFieldElements && !CoreUtils.isNullOrEmpty(readResultItem.getSelectionMarks())) {
                PageResult pageResultItem2 = (PageResult)pageResults.get((int)index);
                perPageFormSelectionMarkList = Transforms.getReadResultFormSelectionMarks(readResultItem, pageResultItem2.getPage());
            }
            formPages.add(Transforms.getFormPage(readResultItem, perPageTableList, perPageFormLineList, perPageFormSelectionMarkList));
        });
        return formPages;
    }

    static List<FormSelectionMark> getReadResultFormSelectionMarks(ReadResult readResultItem, int pageNumber) {
        return readResultItem.getSelectionMarks().stream().map(selectionMark -> {
            SelectionMarkState selectionMarkState;
            FormSelectionMark formSelectionMark = new FormSelectionMark(null, Transforms.toBoundingBox(selectionMark.getBoundingBox()), pageNumber);
            com.azure.ai.formrecognizer.implementation.models.SelectionMarkState selectionMarkStateImpl = selectionMark.getState();
            if (SelectionMarkState.SELECTED.toString().equals(selectionMarkStateImpl.toString())) {
                selectionMarkState = SelectionMarkState.SELECTED;
            } else if (SelectionMarkState.UNSELECTED.toString().equals(selectionMarkStateImpl.toString())) {
                selectionMarkState = SelectionMarkState.UNSELECTED;
            } else {
                throw (RuntimeException)LOGGER.logThrowableAsError((Throwable)new RuntimeException((Object)((Object)selectionMarkStateImpl) + ", unsupported selection mark state."));
            }
            FormSelectionMarkHelper.setConfidence(formSelectionMark, selectionMark.getConfidence());
            FormSelectionMarkHelper.setState(formSelectionMark, selectionMarkState);
            return formSelectionMark;
        }).collect(Collectors.toList());
    }

    static List<FormTable> getPageTables(PageResult pageResultItem, List<ReadResult> readResults, int pageNumber) {
        if (pageResultItem.getTables() == null) {
            return new ArrayList<FormTable>();
        }
        return pageResultItem.getTables().stream().map(dataTable -> {
            FormTable formTable = new FormTable(dataTable.getRows(), dataTable.getColumns(), dataTable.getCells().stream().map(dataTableCell -> new FormTableCell(dataTableCell.getRowIndex(), dataTableCell.getColumnIndex(), dataTableCell.getRowSpan() == null ? 1 : dataTableCell.getRowSpan(), dataTableCell.getColumnSpan() == null ? 1 : dataTableCell.getColumnSpan(), dataTableCell.getText(), Transforms.toBoundingBox(dataTableCell.getBoundingBox()), dataTableCell.getConfidence(), dataTableCell.isHeader() != null && dataTableCell.isHeader() != false, dataTableCell.isFooter() != null && dataTableCell.isFooter() != false, pageNumber, Transforms.setReferenceElements(dataTableCell.getElements(), readResults))).collect(Collectors.toList()), pageNumber);
            FormTableHelper.setBoundingBox(formTable, Transforms.toBoundingBox(dataTable.getBoundingBox()));
            return formTable;
        }).collect(Collectors.toList());
    }

    static List<FormLine> getReadResultFormLines(ReadResult readResultItem) {
        return readResultItem.getLines().stream().map(textLine -> {
            FormLine formLine = new FormLine(textLine.getText(), Transforms.toBoundingBox(textLine.getBoundingBox()), readResultItem.getPage(), Transforms.toWords(textLine.getWords(), readResultItem.getPage()));
            FormLineHelper.setAppearance(formLine, Transforms.getTextAppearance(textLine));
            return formLine;
        }).collect(Collectors.toList());
    }

    private static TextAppearance getTextAppearance(TextLine textLine) {
        TextAppearance textAppearance = new TextAppearance();
        if (textLine.getAppearance() != null && textLine.getAppearance().getStyle() != null) {
            if (textLine.getAppearance().getStyle().getName() != null) {
                TextAppearanceHelper.setStyleName(textAppearance, TextStyleName.fromString(textLine.getAppearance().getStyle().getName().toString()));
            }
        } else {
            return null;
        }
        TextAppearanceHelper.setStyleConfidence(textAppearance, textLine.getAppearance().getStyle().getConfidence());
        return textAppearance;
    }

    private static Map<String, FormField> getLabeledFieldMap(DocumentResult documentResultItem, List<ReadResult> readResults) {
        LinkedHashMap<String, FormField> recognizedFieldMap = new LinkedHashMap<String, FormField>();
        if (!CoreUtils.isNullOrEmpty(documentResultItem.getFields())) {
            documentResultItem.getFields().forEach((key, fieldValue) -> {
                if (fieldValue != null) {
                    List<FormElement> formElementList = Transforms.setReferenceElements(fieldValue.getElements(), readResults);
                    FieldData valueData = fieldValue.getPage() == null && CoreUtils.isNullOrEmpty(fieldValue.getBoundingBox()) ? null : new FieldData(fieldValue.getText(), Transforms.toBoundingBox(fieldValue.getBoundingBox()), fieldValue.getPage(), formElementList);
                    recognizedFieldMap.put((String)key, Transforms.setFormField(key, valueData, fieldValue, readResults));
                } else {
                    recognizedFieldMap.put((String)key, new FormField((String)key, null, null, null, 1.0f));
                }
            });
        }
        return recognizedFieldMap;
    }

    private static FormField setFormField(String name, FieldData valueData, com.azure.ai.formrecognizer.implementation.models.FieldValue fieldValue, List<ReadResult> readResults) {
        FieldValue value;
        switch (fieldValue.getType()) {
            case PHONE_NUMBER: {
                value = new FieldValue(fieldValue.getValuePhoneNumber(), com.azure.ai.formrecognizer.models.FieldValueType.PHONE_NUMBER);
                break;
            }
            case STRING: {
                value = new FieldValue(fieldValue.getValueString(), com.azure.ai.formrecognizer.models.FieldValueType.STRING);
                break;
            }
            case TIME: {
                if (fieldValue.getValueTime() != null) {
                    LocalTime fieldTime = LocalTime.parse(fieldValue.getValueTime(), DateTimeFormatter.ofPattern("HH:mm:ss"));
                    value = new FieldValue(fieldTime, com.azure.ai.formrecognizer.models.FieldValueType.TIME);
                    break;
                }
                value = new FieldValue(null, com.azure.ai.formrecognizer.models.FieldValueType.TIME);
                break;
            }
            case DATE: {
                value = new FieldValue(fieldValue.getValueDate(), com.azure.ai.formrecognizer.models.FieldValueType.DATE);
                break;
            }
            case INTEGER: {
                if (fieldValue.getValueInteger() != null) {
                    value = new FieldValue(fieldValue.getValueInteger().longValue(), com.azure.ai.formrecognizer.models.FieldValueType.LONG);
                    break;
                }
                value = new FieldValue(null, com.azure.ai.formrecognizer.models.FieldValueType.LONG);
                break;
            }
            case NUMBER: {
                value = new FieldValue(fieldValue.getValueNumber(), com.azure.ai.formrecognizer.models.FieldValueType.FLOAT);
                break;
            }
            case ARRAY: {
                if (fieldValue.getValueArray() != null) {
                    value = new FieldValue(Transforms.toFieldValueArray(fieldValue.getValueArray(), readResults), com.azure.ai.formrecognizer.models.FieldValueType.LIST);
                    break;
                }
                value = new FieldValue(null, com.azure.ai.formrecognizer.models.FieldValueType.LIST);
                break;
            }
            case OBJECT: {
                if (fieldValue.getValueObject() != null) {
                    value = new FieldValue(Transforms.toFieldValueObject(fieldValue.getValueObject(), readResults), com.azure.ai.formrecognizer.models.FieldValueType.MAP);
                    break;
                }
                value = new FieldValue(null, com.azure.ai.formrecognizer.models.FieldValueType.MAP);
                break;
            }
            case SELECTION_MARK: {
                if (fieldValue.getValueSelectionMark() != null) {
                    FieldValueSelectionMark fieldValueSelectionMarkState = fieldValue.getValueSelectionMark();
                    SelectionMarkState selectionMarkState = FieldValueSelectionMark.SELECTED.equals((Object)fieldValueSelectionMarkState) ? SelectionMarkState.SELECTED : (FieldValueSelectionMark.UNSELECTED.equals((Object)fieldValueSelectionMarkState) ? SelectionMarkState.UNSELECTED : SelectionMarkState.fromString(fieldValue.getValueSelectionMark().toString()));
                    value = new FieldValue((Object)selectionMarkState, com.azure.ai.formrecognizer.models.FieldValueType.SELECTION_MARK_STATE);
                    break;
                }
                value = new FieldValue(null, com.azure.ai.formrecognizer.models.FieldValueType.SELECTION_MARK_STATE);
                break;
            }
            case COUNTRY_REGION: {
                value = new FieldValue(fieldValue.getValueCountryRegion(), com.azure.ai.formrecognizer.models.FieldValueType.COUNTRY_REGION);
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new RuntimeException("FieldValue Type not supported"));
            }
        }
        return new FormField(name, null, valueData, value, Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()));
    }

    private static float setDefaultConfidenceValue(Float confidence) {
        return confidence == null ? 1.0f : confidence.floatValue();
    }

    private static Map<String, FormField> toFieldValueObject(Map<String, com.azure.ai.formrecognizer.implementation.models.FieldValue> valueObject, List<ReadResult> readResults) {
        TreeMap<String, FormField> fieldValueObjectMap = new TreeMap<String, FormField>();
        valueObject.forEach((key, fieldValue) -> {
            FieldData valueData = null;
            if (fieldValue.getPage() != null && fieldValue.getBoundingBox() != null) {
                valueData = new FieldData(fieldValue.getText(), Transforms.toBoundingBox(fieldValue.getBoundingBox()), fieldValue.getPage(), Transforms.setReferenceElements(fieldValue.getElements(), readResults));
            }
            fieldValueObjectMap.put((String)key, Transforms.setFormField(key, valueData, fieldValue, readResults));
        });
        return fieldValueObjectMap;
    }

    private static List<FormField> toFieldValueArray(List<com.azure.ai.formrecognizer.implementation.models.FieldValue> valueArray, List<ReadResult> readResults) {
        return valueArray.stream().map(fieldValue -> {
            FieldData valueData = null;
            if (FieldValueType.ARRAY != fieldValue.getType() && fieldValue.getPage() != null && fieldValue.getBoundingBox() != null) {
                valueData = new FieldData(fieldValue.getText(), Transforms.toBoundingBox(fieldValue.getBoundingBox()), fieldValue.getPage(), Transforms.setReferenceElements(fieldValue.getElements(), readResults));
            }
            return Transforms.setFormField(null, valueData, fieldValue, readResults);
        }).collect(Collectors.toList());
    }

    private static FormPage getFormPage(ReadResult readResultItem, List<FormTable> perPageTableList, List<FormLine> perPageLineList, List<FormSelectionMark> perPageSelectionMarkList) {
        FormPage formPage = new FormPage(readResultItem.getHeight(), readResultItem.getAngle(), LengthUnit.fromString(readResultItem.getUnit().toString()), readResultItem.getWidth(), perPageLineList, perPageTableList, readResultItem.getPage());
        FormPageHelper.setSelectionMarks(formPage, perPageSelectionMarkList);
        return formPage;
    }

    private static Map<String, FormField> getUnlabeledFieldMap(boolean includeFieldElements, List<ReadResult> readResults, PageResult pageResultItem, int pageNumber) {
        LinkedHashMap<String, FormField> formFieldMap = new LinkedHashMap<String, FormField>();
        List<KeyValuePair> keyValuePairs = pageResultItem.getKeyValuePairs();
        Utility.forEachWithIndex(keyValuePairs, (index, keyValuePair) -> {
            ArrayList<FormElement> formKeyContentList = new ArrayList();
            ArrayList<FormElement> formValueContentList = new ArrayList();
            if (includeFieldElements) {
                formKeyContentList = Transforms.setReferenceElements(keyValuePair.getKey().getElements(), readResults);
                formValueContentList = Transforms.setReferenceElements(keyValuePair.getValue().getElements(), readResults);
            }
            FieldData labelData = new FieldData(keyValuePair.getKey().getText(), Transforms.toBoundingBox(keyValuePair.getKey().getBoundingBox()), pageNumber, formKeyContentList);
            FieldData valueData = new FieldData(keyValuePair.getValue().getText(), Transforms.toBoundingBox(keyValuePair.getValue().getBoundingBox()), pageNumber, formValueContentList);
            String fieldName = "field-" + index;
            FormField formField = new FormField(fieldName, labelData, valueData, new FieldValue(keyValuePair.getValue().getText(), com.azure.ai.formrecognizer.models.FieldValueType.STRING), Transforms.setDefaultConfidenceValue(Float.valueOf(keyValuePair.getConfidence())));
            formFieldMap.put(fieldName, formField);
        });
        return formFieldMap;
    }

    private static List<FormElement> setReferenceElements(List<String> elements, List<ReadResult> readResults) {
        if (CoreUtils.isNullOrEmpty(elements)) {
            return new ArrayList<FormElement>();
        }
        ArrayList<FormElement> formElementList = new ArrayList<FormElement>();
        elements.forEach(elementString -> {
            Matcher selectionMarkMatcher;
            Matcher lineMatcher;
            Matcher wordMatcher = WORD_PATTERN.matcher((CharSequence)elementString);
            if (wordMatcher.find() && wordMatcher.groupCount() == 3) {
                int pageIndex = Integer.parseInt(wordMatcher.group(1));
                int lineIndex = Integer.parseInt(wordMatcher.group(2));
                int wordIndex = Integer.parseInt(wordMatcher.group(3));
                TextWord textWord = ((ReadResult)readResults.get(pageIndex)).getLines().get(lineIndex).getWords().get(wordIndex);
                FormWord wordElement = new FormWord(textWord.getText(), Transforms.toBoundingBox(textWord.getBoundingBox()), pageIndex + 1, Transforms.setDefaultConfidenceValue(textWord.getConfidence()));
                formElementList.add(wordElement);
            }
            if ((lineMatcher = LINE_PATTERN.matcher((CharSequence)elementString)).find() && lineMatcher.groupCount() == 2) {
                int pageIndex = Integer.parseInt(lineMatcher.group(1));
                int lineIndex = Integer.parseInt(lineMatcher.group(2));
                TextLine textLine = ((ReadResult)readResults.get(pageIndex)).getLines().get(lineIndex);
                FormLine lineElement = new FormLine(textLine.getText(), Transforms.toBoundingBox(textLine.getBoundingBox()), pageIndex + 1, Transforms.toWords(textLine.getWords(), pageIndex + 1));
                FormLineHelper.setAppearance(lineElement, Transforms.getTextAppearance(textLine));
                formElementList.add(lineElement);
            }
            if ((selectionMarkMatcher = SELECTION_MARK_PATTERN.matcher((CharSequence)elementString)).find() && selectionMarkMatcher.groupCount() == 2) {
                int pageIndex = Integer.parseInt(selectionMarkMatcher.group(1));
                int selectionMarkIndex = Integer.parseInt(selectionMarkMatcher.group(2));
                SelectionMark selectionMark = ((ReadResult)readResults.get(pageIndex)).getSelectionMarks().get(selectionMarkIndex);
                FormSelectionMark selectionMarkElement = new FormSelectionMark(null, Transforms.toBoundingBox(selectionMark.getBoundingBox()), pageIndex + 1);
                FormSelectionMarkHelper.setState(selectionMarkElement, SelectionMarkState.fromString(selectionMark.getState().toString()));
                formElementList.add(selectionMarkElement);
            }
        });
        return formElementList;
    }

    private static List<FormWord> toWords(List<TextWord> words, int pageNumber) {
        return words.stream().map(textWord -> new FormWord(textWord.getText(), Transforms.toBoundingBox(textWord.getBoundingBox()), pageNumber, Transforms.setDefaultConfidenceValue(textWord.getConfidence()))).collect(Collectors.toList());
    }

    private static FieldBoundingBox toBoundingBox(List<Float> serviceBoundingBox) {
        if (CoreUtils.isNullOrEmpty(serviceBoundingBox) || serviceBoundingBox.size() % 2 != 0) {
            return null;
        }
        ArrayList<Point> pointList = new ArrayList<Point>();
        for (int i = 0; i < serviceBoundingBox.size(); ++i) {
            pointList.add(new Point(serviceBoundingBox.get(i).floatValue(), serviceBoundingBox.get(++i).floatValue()));
        }
        return new FieldBoundingBox(pointList);
    }
}

