/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.util;

import com.azure.ai.formrecognizer.documentanalysis.administration.models.BlobContentSource;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.BlobFileListContentSource;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.BuildDocumentModelOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ComposeDocumentModelOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ContentSource;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.CopyAuthorizationOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentFieldSchema;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelBuildMode;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelBuildOperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelComposeOperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelCopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentTypeDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationKind;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationStatus;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AddressValue;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResult;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AzureBlobContentSource;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AzureBlobFileListContentSource;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BoundingRegion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentClassifierRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ClassifierDocumentTypeDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComponentDocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentBarcode;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentBuildMode;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifierDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentField;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentFieldType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentKeyValueElement;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentPage;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.Error;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.InnerError;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.QuotaDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ResourceDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.AddressValueHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.AnalyzeResultHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.AnalyzedDocumentHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.BoundingRegionHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.CurrencyValueHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentBarcodeHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentClassifierDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentFieldHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentFieldSchemaHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentFormulaHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentKeyValueElementHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentKeyValuePairHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentLanguageHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentLineHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentModelBuildOperationDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentModelComposeOperationDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentModelCopyToOperationDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentModelDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentModelSummaryHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentPageHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentParagraphHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentSelectionMarkHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentSpanHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentStyleHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentTableCellHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentTableHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentTypeDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentWordHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.OperationDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.OperationResultHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.OperationSummaryHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.PointHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.QuotaDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.ResourceDetailsHelper;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Utility;
import com.azure.ai.formrecognizer.documentanalysis.models.AnalyzedDocument;
import com.azure.ai.formrecognizer.documentanalysis.models.CurrencyValue;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentBarcodeKind;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentFormula;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentFormulaKind;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentKeyValuePair;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentLanguage;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentLine;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentPageLengthUnit;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentParagraph;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentSelectionMark;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentSelectionMarkState;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentSignatureType;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentStyle;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentTable;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentTableCell;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentTableCellKind;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentWord;
import com.azure.ai.formrecognizer.documentanalysis.models.FontStyle;
import com.azure.ai.formrecognizer.documentanalysis.models.FontWeight;
import com.azure.ai.formrecognizer.documentanalysis.models.OperationResult;
import com.azure.ai.formrecognizer.documentanalysis.models.ParagraphRole;
import com.azure.ai.formrecognizer.documentanalysis.models.Point;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.models.ResponseError;
import com.azure.core.util.CoreUtils;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Transforms {
    public static com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeResult toAnalyzeResultOperation(AnalyzeResult innerAnalyzeResult) {
        com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeResult analyzeResult = new com.azure.ai.formrecognizer.documentanalysis.models.AnalyzeResult();
        AnalyzeResultHelper.setServiceVersion(analyzeResult, innerAnalyzeResult.getApiVersion());
        if (!CoreUtils.isNullOrEmpty(innerAnalyzeResult.getDocuments())) {
            AnalyzeResultHelper.setDocuments(analyzeResult, innerAnalyzeResult.getDocuments().stream().map(document -> {
                AnalyzedDocument analyzedDocument = new AnalyzedDocument();
                AnalyzedDocumentHelper.setBoundingRegions(analyzedDocument, Transforms.toBoundingRegions(document.getBoundingRegions()));
                AnalyzedDocumentHelper.setConfidence(analyzedDocument, document.getConfidence());
                AnalyzedDocumentHelper.setDocType(analyzedDocument, document.getDocType());
                AnalyzedDocumentHelper.setFields(analyzedDocument, Transforms.toDocumentFields(document.getFields()));
                AnalyzedDocumentHelper.setSpans(analyzedDocument, Transforms.toDocumentSpans(document.getSpans()));
                return analyzedDocument;
            }).collect(Collectors.toList()));
        }
        AnalyzeResultHelper.setContent(analyzeResult, innerAnalyzeResult.getContent());
        AnalyzeResultHelper.setModelId(analyzeResult, innerAnalyzeResult.getModelId());
        if (!CoreUtils.isNullOrEmpty(innerAnalyzeResult.getLanguages())) {
            AnalyzeResultHelper.setLanguages(analyzeResult, innerAnalyzeResult.getLanguages().stream().map(innerLanguage -> {
                DocumentLanguage documentLanguage = new DocumentLanguage();
                DocumentLanguageHelper.setLocale(documentLanguage, innerLanguage.getLocale());
                DocumentLanguageHelper.setSpans(documentLanguage, Transforms.toDocumentSpans(innerLanguage.getSpans()));
                DocumentLanguageHelper.setConfidence(documentLanguage, Float.valueOf(innerLanguage.getConfidence()));
                return documentLanguage;
            }).collect(Collectors.toList()));
        }
        AnalyzeResultHelper.setPages(analyzeResult, innerAnalyzeResult.getPages().stream().map(innerDocumentPage -> {
            com.azure.ai.formrecognizer.documentanalysis.models.DocumentPage documentPage = new com.azure.ai.formrecognizer.documentanalysis.models.DocumentPage();
            DocumentPageHelper.setAngle(documentPage, innerDocumentPage.getAngle());
            DocumentPageHelper.setHeight(documentPage, innerDocumentPage.getHeight());
            DocumentPageHelper.setWidth(documentPage, innerDocumentPage.getWidth());
            DocumentPageHelper.setPageNumber(documentPage, innerDocumentPage.getPageNumber());
            DocumentPageHelper.setUnit(documentPage, innerDocumentPage.getUnit() == null ? null : DocumentPageLengthUnit.fromString(innerDocumentPage.getUnit().toString()));
            DocumentPageHelper.setSpans(documentPage, Transforms.toDocumentSpans(innerDocumentPage.getSpans()));
            DocumentPageHelper.setSelectionMarks(documentPage, innerDocumentPage.getSelectionMarks() == null ? null : innerDocumentPage.getSelectionMarks().stream().map(innerSelectionMark -> {
                DocumentSelectionMark documentSelectionMark = new DocumentSelectionMark();
                DocumentSelectionMarkHelper.setBoundingPolygon(documentSelectionMark, Transforms.toPolygonPoints(innerSelectionMark.getPolygon()));
                DocumentSelectionMarkHelper.setConfidence(documentSelectionMark, innerSelectionMark.getConfidence());
                DocumentSelectionMarkHelper.setSpan(documentSelectionMark, Transforms.getDocumentSpan(innerSelectionMark.getSpan()));
                DocumentSelectionMarkHelper.setState(documentSelectionMark, DocumentSelectionMarkState.fromString(innerSelectionMark.getState().toString()));
                return documentSelectionMark;
            }).collect(Collectors.toList()));
            DocumentPageHelper.setLines(documentPage, innerDocumentPage.getLines() == null ? null : innerDocumentPage.getLines().stream().map(innerDocumentLine -> {
                DocumentLine documentLine = new DocumentLine();
                DocumentLineHelper.setBoundingPolygon(documentLine, Transforms.toPolygonPoints(innerDocumentLine.getPolygon()));
                DocumentLineHelper.setContent(documentLine, innerDocumentLine.getContent());
                DocumentLineHelper.setSpans(documentLine, Transforms.toDocumentSpans(innerDocumentLine.getSpans()));
                DocumentLineHelper.setPageWords(documentLine, Transforms.toDocumentWords(innerDocumentPage));
                return documentLine;
            }).collect(Collectors.toList()));
            DocumentPageHelper.setWords(documentPage, Transforms.toDocumentWords(innerDocumentPage));
            DocumentPageHelper.setFormulas(documentPage, Transforms.fromInnerFormulas(innerDocumentPage.getFormulas()));
            DocumentPageHelper.setBarcodes(documentPage, Transforms.fromInnerBarcodes(innerDocumentPage.getBarcodes()));
            return documentPage;
        }).collect(Collectors.toList()));
        if (!CoreUtils.isNullOrEmpty(innerAnalyzeResult.getKeyValuePairs())) {
            AnalyzeResultHelper.setKeyValuePairs(analyzeResult, innerAnalyzeResult.getKeyValuePairs().stream().map(innerKeyValuePair -> {
                DocumentKeyValuePair documentKeyValuePair = new DocumentKeyValuePair();
                DocumentKeyValuePairHelper.setValue(documentKeyValuePair, Transforms.toDocumentKeyValueElement(innerKeyValuePair.getValue()));
                DocumentKeyValuePairHelper.setKey(documentKeyValuePair, Transforms.toDocumentKeyValueElement(innerKeyValuePair.getKey()));
                DocumentKeyValuePairHelper.setConfidence(documentKeyValuePair, innerKeyValuePair.getConfidence());
                return documentKeyValuePair;
            }).collect(Collectors.toList()));
        }
        if (!CoreUtils.isNullOrEmpty(innerAnalyzeResult.getStyles())) {
            AnalyzeResultHelper.setStyles(analyzeResult, innerAnalyzeResult.getStyles().stream().map(innerDocumentStyle -> {
                DocumentStyle documentStyle = new DocumentStyle();
                DocumentStyleHelper.setConfidence(documentStyle, Float.valueOf(innerDocumentStyle.getConfidence()));
                DocumentStyleHelper.setIsHandwritten(documentStyle, innerDocumentStyle.isHandwritten());
                DocumentStyleHelper.setSpans(documentStyle, Transforms.toDocumentSpans(innerDocumentStyle.getSpans()));
                DocumentStyleHelper.setColor(documentStyle, innerDocumentStyle.getColor());
                DocumentStyleHelper.setBackgroundColor(documentStyle, innerDocumentStyle.getBackgroundColor());
                if (innerDocumentStyle.getFontWeight() != null) {
                    DocumentStyleHelper.setFontWeight(documentStyle, FontWeight.fromString(innerDocumentStyle.getFontWeight().toString()));
                }
                DocumentStyleHelper.setSimilarFontFamily(documentStyle, innerDocumentStyle.getSimilarFontFamily());
                if (innerDocumentStyle.getFontStyle() != null) {
                    DocumentStyleHelper.setFontStyle(documentStyle, FontStyle.fromString(innerDocumentStyle.getFontStyle().toString()));
                }
                return documentStyle;
            }).collect(Collectors.toList()));
        }
        if (!CoreUtils.isNullOrEmpty(innerAnalyzeResult.getParagraphs())) {
            AnalyzeResultHelper.setParagraphs(analyzeResult, innerAnalyzeResult.getParagraphs().stream().map(innerParagraph -> {
                DocumentParagraph documentParagraph = new DocumentParagraph();
                DocumentParagraphHelper.setContent(documentParagraph, innerParagraph.getContent());
                DocumentParagraphHelper.setRole(documentParagraph, innerParagraph.getRole() == null ? null : ParagraphRole.fromString(innerParagraph.getRole().toString()));
                DocumentParagraphHelper.setBoundingRegions(documentParagraph, Transforms.toBoundingRegions(innerParagraph.getBoundingRegions()));
                DocumentParagraphHelper.setSpans(documentParagraph, Transforms.toDocumentSpans(innerParagraph.getSpans()));
                return documentParagraph;
            }).collect(Collectors.toList()));
        }
        if (!CoreUtils.isNullOrEmpty(innerAnalyzeResult.getTables())) {
            AnalyzeResultHelper.setTables(analyzeResult, innerAnalyzeResult.getTables().stream().map(innerDocumentTable -> {
                DocumentTable documentTable = new DocumentTable();
                DocumentTableHelper.setCells(documentTable, innerDocumentTable.getCells().stream().map(innerDocumentCell -> {
                    DocumentTableCell documentTableCell = new DocumentTableCell();
                    DocumentTableCellHelper.setBoundingRegions(documentTableCell, Transforms.toBoundingRegions(innerDocumentCell.getBoundingRegions()));
                    DocumentTableCellHelper.setSpans(documentTableCell, Transforms.toDocumentSpans(innerDocumentCell.getSpans()));
                    DocumentTableCellHelper.setContent(documentTableCell, innerDocumentCell.getContent());
                    DocumentTableCellHelper.setColumnIndex(documentTableCell, innerDocumentCell.getColumnIndex());
                    DocumentTableCellHelper.setKind(documentTableCell, innerDocumentCell.getKind() == null ? DocumentTableCellKind.CONTENT : DocumentTableCellKind.fromString(innerDocumentCell.getKind().toString()));
                    DocumentTableCellHelper.setRowIndex(documentTableCell, innerDocumentCell.getRowIndex());
                    DocumentTableCellHelper.setColumnSpan(documentTableCell, innerDocumentCell.getColumnSpan());
                    DocumentTableCellHelper.setRowSpan(documentTableCell, innerDocumentCell.getRowSpan());
                    return documentTableCell;
                }).collect(Collectors.toList()));
                DocumentTableHelper.setBoundingRegions(documentTable, Transforms.toBoundingRegions(innerDocumentTable.getBoundingRegions()));
                DocumentTableHelper.setSpans(documentTable, Transforms.toDocumentSpans(innerDocumentTable.getSpans()));
                DocumentTableHelper.setColumnCount(documentTable, innerDocumentTable.getColumnCount());
                DocumentTableHelper.setRowCount(documentTable, innerDocumentTable.getRowCount());
                return documentTable;
            }).collect(Collectors.toList()));
        }
        return analyzeResult;
    }

    private static List<com.azure.ai.formrecognizer.documentanalysis.models.DocumentBarcode> fromInnerBarcodes(List<DocumentBarcode> barcodes) {
        if (barcodes != null) {
            return barcodes.stream().map(innerBarcode -> {
                com.azure.ai.formrecognizer.documentanalysis.models.DocumentBarcode documentBarcode = new com.azure.ai.formrecognizer.documentanalysis.models.DocumentBarcode();
                DocumentBarcodeHelper.setKind(documentBarcode, innerBarcode.getKind() == null ? null : DocumentBarcodeKind.fromString(innerBarcode.getKind().toString()));
                DocumentBarcodeHelper.setValue(documentBarcode, innerBarcode.getValue());
                DocumentBarcodeHelper.setConfidence(documentBarcode, innerBarcode.getConfidence());
                DocumentBarcodeHelper.setSpan(documentBarcode, Transforms.getDocumentSpan(innerBarcode.getSpan()));
                DocumentBarcodeHelper.setBoundingPolygon(documentBarcode, Transforms.toPolygonPoints(innerBarcode.getPolygon()));
                return documentBarcode;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private static List<DocumentFormula> fromInnerFormulas(List<com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentFormula> formulas) {
        if (formulas != null) {
            return formulas.stream().map(innerFormula -> {
                DocumentFormula documentFormula = new DocumentFormula();
                DocumentFormulaHelper.setKind(documentFormula, innerFormula.getKind() == null ? null : DocumentFormulaKind.fromString(innerFormula.getKind().toString()));
                DocumentFormulaHelper.setValue(documentFormula, innerFormula.getValue());
                DocumentFormulaHelper.setConfidence(documentFormula, innerFormula.getConfidence());
                DocumentFormulaHelper.setSpan(documentFormula, Transforms.getDocumentSpan(innerFormula.getSpan()));
                DocumentFormulaHelper.setBoundingPolygon(documentFormula, Transforms.toPolygonPoints(innerFormula.getPolygon()));
                return documentFormula;
            }).collect(Collectors.toList());
        }
        return null;
    }

    public static BuildDocumentModelRequest getBuildDocumentModelRequest(ContentSource contentSource, DocumentModelBuildMode buildMode, String modelId, BuildDocumentModelOptions buildDocumentModelOptions) {
        BuildDocumentModelRequest buildDocumentModelRequest = new BuildDocumentModelRequest(modelId, DocumentBuildMode.fromString(buildMode.toString())).setDescription(buildDocumentModelOptions.getDescription()).setTags(buildDocumentModelOptions.getTags());
        if (contentSource instanceof BlobContentSource) {
            BlobContentSource azureBlobSource = (BlobContentSource)contentSource;
            buildDocumentModelRequest.setAzureBlobSource(new AzureBlobContentSource(azureBlobSource.getContainerUrl()).setPrefix(azureBlobSource.getPrefix()));
        } else if (contentSource instanceof BlobFileListContentSource) {
            BlobFileListContentSource azureBlobFileListSource = (BlobFileListContentSource)contentSource;
            buildDocumentModelRequest.setAzureBlobFileListSource(new AzureBlobFileListContentSource(azureBlobFileListSource.getContainerUrl(), azureBlobFileListSource.getFileList()));
        }
        return buildDocumentModelRequest;
    }

    public static BuildDocumentClassifierRequest getBuildDocumentClassifierRequest(String classifierId, String description, Map<String, ClassifierDocumentTypeDetails> docTypes) {
        return new BuildDocumentClassifierRequest(classifierId, docTypes).setDescription(description);
    }

    public static Throwable mapToHttpResponseExceptionIfExists(Throwable throwable) {
        if (throwable instanceof ErrorResponseException) {
            return Transforms.getHttpResponseException((ErrorResponseException)((Object)throwable));
        }
        return throwable;
    }

    public static HttpResponseException getHttpResponseException(ErrorResponseException throwable) {
        Error error = null;
        if (throwable.getValue() != null && throwable.getValue().getError() != null) {
            error = throwable.getValue().getError();
        }
        return new HttpResponseException(throwable.getMessage(), throwable.getResponse(), (Object)Transforms.toResponseError(error));
    }

    public static HttpResponseException mapResponseErrorToHttpResponseException(Error error) {
        return new HttpResponseException(error.getMessage(), null, (Object)Transforms.toResponseError(error));
    }

    public static DocumentModelCopyAuthorization toCopyAuthorization(CopyAuthorization innerCopyAuthorization) {
        return new DocumentModelCopyAuthorization(innerCopyAuthorization.getTargetResourceId(), innerCopyAuthorization.getTargetResourceRegion(), innerCopyAuthorization.getTargetModelId(), innerCopyAuthorization.getTargetModelLocation(), innerCopyAuthorization.getAccessToken(), innerCopyAuthorization.getExpirationDateTime());
    }

    public static com.azure.ai.formrecognizer.documentanalysis.administration.models.ResourceDetails toAccountProperties(ResourceDetails getInfoResponse) {
        com.azure.ai.formrecognizer.documentanalysis.administration.models.ResourceDetails resourceDetails = new com.azure.ai.formrecognizer.documentanalysis.administration.models.ResourceDetails();
        ResourceDetailsHelper.setDocumentModelCount(resourceDetails, getInfoResponse.getCustomDocumentModels().getCount());
        ResourceDetailsHelper.setDocumentModelLimit(resourceDetails, getInfoResponse.getCustomDocumentModels().getLimit());
        ResourceDetailsHelper.setCustomNeuralDocumentModelBuilds(resourceDetails, Transforms.toQuotaDetails(getInfoResponse.getCustomNeuralDocumentModelBuilds()));
        return resourceDetails;
    }

    public static com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelDetails toDocumentModelFromOperationId(com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails operationDetails) {
        if (operationDetails instanceof com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelBuildOperationDetails) {
            DocumentModelDetails buildOperationModelResult = ((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelBuildOperationDetails)operationDetails).getResult();
            return Transforms.toDocumentModelDetails(buildOperationModelResult);
        }
        if (operationDetails instanceof com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelCopyToOperationDetails) {
            DocumentModelDetails copyOperationModelResult = ((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelCopyToOperationDetails)operationDetails).getResult();
            return Transforms.toDocumentModelDetails(copyOperationModelResult);
        }
        if (operationDetails instanceof com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelComposeOperationDetails) {
            DocumentModelDetails composeOperationModelResult = ((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelComposeOperationDetails)operationDetails).getResult();
            return Transforms.toDocumentModelDetails(composeOperationModelResult);
        }
        return new com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelDetails();
    }

    public static com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentClassifierDetails toDocumentClassifierFromOperationId(com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails operationDetails) {
        if (operationDetails instanceof DocumentClassifierBuildOperationDetails) {
            DocumentClassifierDetails classifierDetails = ((DocumentClassifierBuildOperationDetails)operationDetails).getResult();
            return Transforms.fromInnerDocumentClassifierDetails(classifierDetails);
        }
        return null;
    }

    public static com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelDetails toDocumentModelDetails(DocumentModelDetails modelDetails) {
        com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelDetails documentModelDetails = new com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelDetails();
        if (modelDetails != null) {
            DocumentModelDetailsHelper.setModelId(documentModelDetails, modelDetails.getModelId());
            DocumentModelDetailsHelper.setDescription(documentModelDetails, modelDetails.getDescription());
            Map<String, DocumentTypeDetails> docTypeMap = Transforms.getStringDocTypeInfoMap(modelDetails);
            DocumentModelDetailsHelper.setDocTypes(documentModelDetails, docTypeMap);
            DocumentModelDetailsHelper.setCreatedOn(documentModelDetails, modelDetails.getCreatedDateTime());
            DocumentModelDetailsHelper.setTags(documentModelDetails, modelDetails.getTags());
            DocumentModelDetailsHelper.setExpiresOn(documentModelDetails, modelDetails.getExpirationDateTime());
            DocumentModelDetailsHelper.setServiceVersion(documentModelDetails, modelDetails.getApiVersion());
        }
        return documentModelDetails;
    }

    private static Map<String, DocumentTypeDetails> getStringDocTypeInfoMap(DocumentModelDetails modelInfo) {
        if (!CoreUtils.isNullOrEmpty(modelInfo.getDocTypes())) {
            HashMap<String, DocumentTypeDetails> docTypeMap = new HashMap<String, DocumentTypeDetails>();
            modelInfo.getDocTypes().forEach((key, innerDocTypeInfo) -> {
                DocumentTypeDetails documentTypeDetails = new DocumentTypeDetails();
                DocumentTypeDetailsHelper.setDescription(documentTypeDetails, innerDocTypeInfo.getDescription());
                HashMap<String, DocumentFieldSchema> schemaMap = new HashMap<String, DocumentFieldSchema>();
                innerDocTypeInfo.getFieldSchema().forEach((schemaKey, innerDocSchema) -> schemaMap.put((String)schemaKey, Transforms.toDocumentFieldSchema(innerDocSchema)));
                DocumentTypeDetailsHelper.setFieldSchema(documentTypeDetails, schemaMap);
                DocumentTypeDetailsHelper.setFieldConfidence(documentTypeDetails, innerDocTypeInfo.getFieldConfidence());
                docTypeMap.put((String)key, documentTypeDetails);
                DocumentTypeDetailsHelper.setBuildMode(documentTypeDetails, innerDocTypeInfo.getBuildMode() != null ? DocumentModelBuildMode.fromString(innerDocTypeInfo.getBuildMode().toString()) : null);
            });
            return docTypeMap;
        }
        return null;
    }

    private static DocumentFieldSchema toDocumentFieldSchema(com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentFieldSchema innerDocSchema) {
        if (innerDocSchema != null) {
            DocumentFieldSchema documentFieldSchema = new DocumentFieldSchema();
            DocumentFieldSchemaHelper.setDescription(documentFieldSchema, innerDocSchema.getDescription());
            DocumentFieldSchemaHelper.setExample(documentFieldSchema, innerDocSchema.getExample());
            DocumentFieldSchemaHelper.setType(documentFieldSchema, com.azure.ai.formrecognizer.documentanalysis.models.DocumentFieldType.fromString(innerDocSchema.getType().toString()));
            if (innerDocSchema.getItems() != null) {
                DocumentFieldSchemaHelper.setItems(documentFieldSchema, Transforms.toDocumentFieldSchema(innerDocSchema.getItems()));
            }
            if (!CoreUtils.isNullOrEmpty(innerDocSchema.getProperties())) {
                DocumentFieldSchemaHelper.setProperties(documentFieldSchema, Transforms.toDocumentFieldProperties(innerDocSchema.getProperties()));
            }
            return documentFieldSchema;
        }
        return null;
    }

    private static Map<String, DocumentFieldSchema> toDocumentFieldProperties(Map<String, com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentFieldSchema> properties) {
        HashMap<String, DocumentFieldSchema> schemaMap = new HashMap<String, DocumentFieldSchema>();
        properties.forEach((key, innerDocFieldSchema) -> schemaMap.put((String)key, Transforms.toDocumentFieldSchema(innerDocFieldSchema)));
        return schemaMap;
    }

    private static com.azure.ai.formrecognizer.documentanalysis.models.DocumentKeyValueElement toDocumentKeyValueElement(DocumentKeyValueElement innerDocKeyValElement) {
        if (innerDocKeyValElement == null) {
            return null;
        }
        com.azure.ai.formrecognizer.documentanalysis.models.DocumentKeyValueElement documentKeyValueElement = new com.azure.ai.formrecognizer.documentanalysis.models.DocumentKeyValueElement();
        DocumentKeyValueElementHelper.setContent(documentKeyValueElement, innerDocKeyValElement.getContent());
        DocumentKeyValueElementHelper.setBoundingRegions(documentKeyValueElement, Transforms.toBoundingRegions(innerDocKeyValElement.getBoundingRegions()));
        DocumentKeyValueElementHelper.setSpans(documentKeyValueElement, Transforms.toDocumentSpans(innerDocKeyValElement.getSpans()));
        return documentKeyValueElement;
    }

    private static Map<String, com.azure.ai.formrecognizer.documentanalysis.models.DocumentField> toDocumentFields(Map<String, DocumentField> innerFields) {
        HashMap<String, com.azure.ai.formrecognizer.documentanalysis.models.DocumentField> documentFieldMap = new HashMap<String, com.azure.ai.formrecognizer.documentanalysis.models.DocumentField>();
        if (!CoreUtils.isNullOrEmpty(innerFields)) {
            innerFields.forEach((key, innerDocumentField) -> documentFieldMap.put((String)key, Transforms.toDocumentField(innerDocumentField)));
        }
        return documentFieldMap;
    }

    private static com.azure.ai.formrecognizer.documentanalysis.models.DocumentField toDocumentField(DocumentField innerDocumentField) {
        com.azure.ai.formrecognizer.documentanalysis.models.DocumentField documentField = new com.azure.ai.formrecognizer.documentanalysis.models.DocumentField();
        DocumentFieldHelper.setType(documentField, com.azure.ai.formrecognizer.documentanalysis.models.DocumentFieldType.fromString(innerDocumentField.getType().toString()));
        DocumentFieldHelper.setBoundingRegions(documentField, Transforms.toBoundingRegions(innerDocumentField.getBoundingRegions()));
        DocumentFieldHelper.setContent(documentField, innerDocumentField.getContent());
        DocumentFieldHelper.setSpans(documentField, Transforms.toDocumentSpans(innerDocumentField.getSpans()));
        DocumentFieldHelper.setConfidence(documentField, innerDocumentField.getConfidence());
        Transforms.setDocumentFieldValue(innerDocumentField, documentField);
        return documentField;
    }

    private static void setDocumentFieldValue(DocumentField innerDocumentField, com.azure.ai.formrecognizer.documentanalysis.models.DocumentField documentField) {
        if (DocumentFieldType.STRING.equals((Object)innerDocumentField.getType())) {
            DocumentFieldHelper.setValue(documentField, innerDocumentField.getValueString());
        } else if (DocumentFieldType.DATE.equals((Object)innerDocumentField.getType())) {
            DocumentFieldHelper.setValue(documentField, innerDocumentField.getValueDate());
        } else if (DocumentFieldType.TIME.equals((Object)innerDocumentField.getType())) {
            DocumentFieldHelper.setValue(documentField, innerDocumentField.getValueTime() == null ? null : LocalTime.parse(innerDocumentField.getValueTime(), DateTimeFormatter.ofPattern("HH:mm:ss")));
        } else if (DocumentFieldType.PHONE_NUMBER.equals((Object)innerDocumentField.getType())) {
            DocumentFieldHelper.setValue(documentField, innerDocumentField.getValuePhoneNumber());
        } else if (DocumentFieldType.NUMBER.equals((Object)innerDocumentField.getType())) {
            DocumentFieldHelper.setValue(documentField, innerDocumentField.getValueNumber() == null ? null : Double.valueOf(innerDocumentField.getValueNumber().doubleValue()));
        } else if (DocumentFieldType.INTEGER.equals((Object)innerDocumentField.getType())) {
            DocumentFieldHelper.setValue(documentField, innerDocumentField.getValueInteger());
        } else if (DocumentFieldType.SELECTION_MARK.equals((Object)innerDocumentField.getType())) {
            if (innerDocumentField.getValueSelectionMark() == null) {
                DocumentFieldHelper.setValue(documentField, null);
            } else {
                DocumentFieldHelper.setValue(documentField, (Object)DocumentSelectionMarkState.fromString(innerDocumentField.getValueSelectionMark().toString()));
            }
        } else if (DocumentFieldType.COUNTRY_REGION.equals((Object)innerDocumentField.getType())) {
            DocumentFieldHelper.setValue(documentField, innerDocumentField.getValueCountryRegion());
        } else if (DocumentFieldType.SIGNATURE.equals((Object)innerDocumentField.getType())) {
            if (innerDocumentField.getValueSignature() != null) {
                DocumentFieldHelper.setValue(documentField, (Object)DocumentSignatureType.fromString(innerDocumentField.getValueSignature().toString()));
            }
        } else if (DocumentFieldType.ARRAY.equals((Object)innerDocumentField.getType())) {
            if (CoreUtils.isNullOrEmpty(innerDocumentField.getValueArray())) {
                DocumentFieldHelper.setValue(documentField, null);
            } else {
                DocumentFieldHelper.setValue(documentField, innerDocumentField.getValueArray().stream().map(Transforms::toDocumentField).collect(Collectors.toList()));
            }
        } else if (DocumentFieldType.OBJECT.equals((Object)innerDocumentField.getType())) {
            if (CoreUtils.isNullOrEmpty(innerDocumentField.getValueObject())) {
                DocumentFieldHelper.setValue(documentField, null);
            } else {
                HashMap documentFieldMap = new HashMap();
                innerDocumentField.getValueObject().forEach((key, innerMapDocumentField) -> documentFieldMap.put(key, Transforms.toDocumentField(innerMapDocumentField)));
                DocumentFieldHelper.setValue(documentField, documentFieldMap);
            }
        } else if (DocumentFieldType.CURRENCY.equals((Object)innerDocumentField.getType())) {
            if (innerDocumentField.getValueCurrency() == null) {
                DocumentFieldHelper.setValue(documentField, null);
            } else {
                CurrencyValue currencyValue = new CurrencyValue();
                CurrencyValueHelper.setAmount(currencyValue, innerDocumentField.getValueCurrency().getAmount());
                CurrencyValueHelper.setCurrencySymbol(currencyValue, innerDocumentField.getValueCurrency().getCurrencySymbol());
                DocumentFieldHelper.setValue(documentField, currencyValue);
            }
        } else if (DocumentFieldType.ADDRESS.equals((Object)innerDocumentField.getType())) {
            AddressValue innerValueAddress = innerDocumentField.getValueAddress();
            if (innerValueAddress == null) {
                DocumentFieldHelper.setValue(documentField, null);
            } else {
                com.azure.ai.formrecognizer.documentanalysis.models.AddressValue addressValue = new com.azure.ai.formrecognizer.documentanalysis.models.AddressValue();
                AddressValueHelper.setCity(addressValue, innerValueAddress.getCity());
                AddressValueHelper.setStreetAddress(addressValue, innerValueAddress.getStreetAddress());
                AddressValueHelper.setCountryRegion(addressValue, innerValueAddress.getCountryRegion());
                AddressValueHelper.setHouseNumber(addressValue, innerValueAddress.getHouseNumber());
                AddressValueHelper.setRoad(addressValue, innerValueAddress.getRoad());
                AddressValueHelper.setPoBox(addressValue, innerValueAddress.getPoBox());
                AddressValueHelper.setPostalCode(addressValue, innerValueAddress.getPostalCode());
                AddressValueHelper.setState(addressValue, innerValueAddress.getState());
                AddressValueHelper.setUnit(addressValue, innerValueAddress.getUnit());
                AddressValueHelper.setCityDistrict(addressValue, innerValueAddress.getCityDistrict());
                AddressValueHelper.setStateDistrict(addressValue, innerValueAddress.getStateDistrict());
                AddressValueHelper.setSuburb(addressValue, innerValueAddress.getSuburb());
                AddressValueHelper.setHouse(addressValue, innerValueAddress.getHouse());
                AddressValueHelper.setLevel(addressValue, innerValueAddress.getLevel());
                DocumentFieldHelper.setValue(documentField, addressValue);
            }
        }
    }

    private static List<DocumentSpan> toDocumentSpans(List<com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan> innerDocumentSpans) {
        if (!CoreUtils.isNullOrEmpty(innerDocumentSpans)) {
            return innerDocumentSpans.stream().map(Transforms::getDocumentSpan).collect(Collectors.toList());
        }
        return null;
    }

    private static DocumentSpan getDocumentSpan(com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan innerDocumentSpan) {
        DocumentSpan documentSpan = new DocumentSpan();
        DocumentSpanHelper.setLength(documentSpan, innerDocumentSpan.getLength());
        DocumentSpanHelper.setOffset(documentSpan, innerDocumentSpan.getOffset());
        return documentSpan;
    }

    private static List<com.azure.ai.formrecognizer.documentanalysis.models.BoundingRegion> toBoundingRegions(List<BoundingRegion> innerBoundingRegions) {
        if (!CoreUtils.isNullOrEmpty(innerBoundingRegions)) {
            return innerBoundingRegions.stream().map(innerBoundingRegion -> {
                com.azure.ai.formrecognizer.documentanalysis.models.BoundingRegion boundingRegion = new com.azure.ai.formrecognizer.documentanalysis.models.BoundingRegion();
                BoundingRegionHelper.setBoundingPolygon(boundingRegion, Transforms.toPolygonPoints(innerBoundingRegion.getPolygon()));
                BoundingRegionHelper.setPageNumber(boundingRegion, innerBoundingRegion.getPageNumber());
                return boundingRegion;
            }).collect(Collectors.toList());
        }
        return null;
    }

    private static List<Point> toPolygonPoints(List<Float> polygonValues) {
        if (CoreUtils.isNullOrEmpty(polygonValues) || polygonValues.size() % 2 != 0) {
            return null;
        }
        ArrayList<Point> pointList = new ArrayList<Point>();
        for (int i = 0; i < polygonValues.size(); ++i) {
            Point polygonPoint = new Point();
            PointHelper.setX(polygonPoint, polygonValues.get(i).floatValue());
            PointHelper.setY(polygonPoint, polygonValues.get(++i).floatValue());
            pointList.add(polygonPoint);
        }
        return pointList;
    }

    public static List<DocumentModelSummary> toDocumentModelInfo(List<com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelSummary> modelSummaryList) {
        return modelSummaryList.stream().map(modelSummary -> {
            DocumentModelSummary documentModelSummary = new DocumentModelSummary();
            DocumentModelSummaryHelper.setModelId(documentModelSummary, modelSummary.getModelId());
            DocumentModelSummaryHelper.setDescription(documentModelSummary, modelSummary.getDescription());
            DocumentModelSummaryHelper.setCreatedOn(documentModelSummary, modelSummary.getCreatedDateTime());
            DocumentModelSummaryHelper.setTags(documentModelSummary, modelSummary.getTags());
            DocumentModelSummaryHelper.setExpiresOn(documentModelSummary, modelSummary.getExpirationDateTime());
            DocumentModelSummaryHelper.setServiceVersion(documentModelSummary, modelSummary.getApiVersion());
            return documentModelSummary;
        }).collect(Collectors.toList());
    }

    public static OperationDetails toOperationDetails(com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails innerOperationDetails) {
        OperationDetails operationDetails = null;
        if (innerOperationDetails != null) {
            if (innerOperationDetails instanceof com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelBuildOperationDetails) {
                DocumentModelBuildOperationDetails buildOperationDetails = new DocumentModelBuildOperationDetails();
                DocumentModelBuildOperationDetailsHelper.setResult(buildOperationDetails, Transforms.toDocumentModelDetails(((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelBuildOperationDetails)innerOperationDetails).getResult()));
                operationDetails = buildOperationDetails;
            } else if (innerOperationDetails instanceof com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelComposeOperationDetails) {
                DocumentModelComposeOperationDetails composeOperationDetails = new DocumentModelComposeOperationDetails();
                DocumentModelComposeOperationDetailsHelper.setResult(composeOperationDetails, Transforms.toDocumentModelDetails(((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelComposeOperationDetails)innerOperationDetails).getResult()));
                operationDetails = composeOperationDetails;
            } else if (innerOperationDetails instanceof com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelCopyToOperationDetails) {
                DocumentModelCopyToOperationDetails copyToOperationDetails = new DocumentModelCopyToOperationDetails();
                DocumentModelCopyToOperationDetailsHelper.setResult(copyToOperationDetails, Transforms.toDocumentModelDetails(((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelCopyToOperationDetails)innerOperationDetails).getResult()));
                operationDetails = copyToOperationDetails;
            }
            OperationDetailsHelper.setOperationId(operationDetails, innerOperationDetails.getOperationId());
            OperationDetailsHelper.setCreatedOn(operationDetails, innerOperationDetails.getCreatedDateTime());
            OperationDetailsHelper.setLastUpdatedOn(operationDetails, innerOperationDetails.getLastUpdatedDateTime());
            OperationDetailsHelper.setPercentCompleted(operationDetails, innerOperationDetails.getPercentCompleted() == null ? Integer.valueOf(0) : innerOperationDetails.getPercentCompleted());
            OperationDetailsHelper.setStatus(operationDetails, OperationStatus.fromString(innerOperationDetails.getStatus().toString()));
            OperationDetailsHelper.setResourceLocation(operationDetails, innerOperationDetails.getResourceLocation());
            OperationDetailsHelper.setError(operationDetails, Transforms.toResponseError(innerOperationDetails.getError()));
            OperationDetailsHelper.setTags(operationDetails, innerOperationDetails.getTags());
            OperationDetailsHelper.setServiceVersion(operationDetails, innerOperationDetails.getApiVersion());
        }
        return operationDetails;
    }

    public static List<OperationSummary> toOperationSummary(List<com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationSummary> operationSummary) {
        return operationSummary.stream().map(operationSummaryItem -> {
            OperationSummary documentModelOperationSummary = new OperationSummary();
            OperationSummaryHelper.setOperationId(documentModelOperationSummary, operationSummaryItem.getOperationId());
            OperationSummaryHelper.setCreatedOn(documentModelOperationSummary, operationSummaryItem.getCreatedDateTime());
            OperationSummaryHelper.setKind(documentModelOperationSummary, operationSummaryItem.getKind() == null ? null : OperationKind.fromString(operationSummaryItem.getKind().toString()));
            OperationSummaryHelper.setLastUpdatedOn(documentModelOperationSummary, operationSummaryItem.getLastUpdatedDateTime());
            OperationSummaryHelper.setPercentCompleted(documentModelOperationSummary, operationSummaryItem.getPercentCompleted() == null ? Integer.valueOf(0) : operationSummaryItem.getPercentCompleted());
            OperationSummaryHelper.setStatus(documentModelOperationSummary, operationSummaryItem.getStatus() == null ? null : OperationStatus.fromString(operationSummaryItem.getStatus().toString()));
            OperationSummaryHelper.setResourceLocation(documentModelOperationSummary, operationSummaryItem.getResourceLocation());
            OperationSummaryHelper.setTags(documentModelOperationSummary, operationSummaryItem.getTags());
            return documentModelOperationSummary;
        }).collect(Collectors.toList());
    }

    public static OperationResult toDocumentOperationResult(String operationLocation) {
        OperationResult operationResult = new OperationResult();
        OperationResultHelper.setResultId(operationResult, Utility.parseResultId(operationLocation));
        return operationResult;
    }

    public static AuthorizeCopyRequest getAuthorizeCopyRequest(CopyAuthorizationOptions copyAuthorizationOptions, String modelId) {
        return new AuthorizeCopyRequest(modelId).setDescription(copyAuthorizationOptions.getDescription()).setTags(copyAuthorizationOptions.getTags());
    }

    public static ComposeDocumentModelRequest getComposeDocumentModelRequest(List<String> componentModelIds, ComposeDocumentModelOptions composeDocumentModelOptions, String modelId) {
        return new ComposeDocumentModelRequest(modelId, componentModelIds.stream().map(ComponentDocumentModelDetails::new).collect(Collectors.toList())).setDescription(composeDocumentModelOptions.getDescription()).setTags(composeDocumentModelOptions.getTags());
    }

    public static CopyAuthorization getInnerCopyAuthorization(DocumentModelCopyAuthorization target) {
        return new CopyAuthorization(target.getTargetResourceId(), target.getTargetResourceRegion(), target.getTargetModelId(), target.getTargetModelLocation(), target.getAccessToken(), target.getExpiresOn());
    }

    private static ResponseError toResponseError(Error error) {
        if (error == null) {
            return null;
        }
        InnerError innerError = error.getInnererror();
        String message = error.getMessage();
        StringBuilder errorInformationStringBuilder = new StringBuilder().append(message);
        if (innerError != null) {
            errorInformationStringBuilder.append(", errorCode: [").append(innerError.getCode()).append("], ").append("message").append(": ").append(innerError.getMessage());
        }
        return new ResponseError(error.getCode(), errorInformationStringBuilder.toString());
    }

    private static List<DocumentWord> toDocumentWords(DocumentPage innerDocumentPage) {
        return innerDocumentPage.getWords() == null ? null : innerDocumentPage.getWords().stream().map(innerDocumentWord -> {
            DocumentWord documentWord = new DocumentWord();
            DocumentWordHelper.setBoundingPolygon(documentWord, Transforms.toPolygonPoints(innerDocumentWord.getPolygon()));
            DocumentWordHelper.setConfidence(documentWord, innerDocumentWord.getConfidence());
            DocumentWordHelper.setSpan(documentWord, Transforms.getDocumentSpan(innerDocumentWord.getSpan()));
            DocumentWordHelper.setContent(documentWord, innerDocumentWord.getContent());
            return documentWord;
        }).collect(Collectors.toList());
    }

    public static Map<String, ClassifierDocumentTypeDetails> toInnerDocTypes(Map<String, com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails> tags) {
        HashMap<String, ClassifierDocumentTypeDetails> innerTags = new HashMap<String, ClassifierDocumentTypeDetails>();
        tags.forEach((key, classifierDocumentTypeDetails) -> {
            ClassifierDocumentTypeDetails innerClassifyDocTypeDetails = new ClassifierDocumentTypeDetails();
            if (classifierDocumentTypeDetails.getContentSource() instanceof BlobFileListContentSource) {
                innerClassifyDocTypeDetails.setAzureBlobFileListSource(new AzureBlobFileListContentSource(((BlobFileListContentSource)classifierDocumentTypeDetails.getContentSource()).getContainerUrl(), ((BlobFileListContentSource)classifierDocumentTypeDetails.getContentSource()).getFileList()));
            } else {
                innerClassifyDocTypeDetails.setAzureBlobSource(new AzureBlobContentSource(((BlobContentSource)classifierDocumentTypeDetails.getContentSource()).getContainerUrl()).setPrefix(((BlobContentSource)classifierDocumentTypeDetails.getContentSource()).getPrefix()));
            }
            innerTags.put((String)key, innerClassifyDocTypeDetails);
        });
        return innerTags;
    }

    public static com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentClassifierDetails fromInnerDocumentClassifierDetails(DocumentClassifierDetails inner) {
        com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentClassifierDetails classifierDetails = new com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentClassifierDetails();
        DocumentClassifierDetailsHelper.setClassifierId(classifierDetails, inner.getClassifierId());
        DocumentClassifierDetailsHelper.setDescription(classifierDetails, inner.getDescription());
        DocumentClassifierDetailsHelper.setDocTypes(classifierDetails, Transforms.fromInnerDocTypes(inner.getDocTypes()));
        DocumentClassifierDetailsHelper.setServiceVersion(classifierDetails, inner.getApiVersion());
        DocumentClassifierDetailsHelper.setCreatedOn(classifierDetails, inner.getCreatedDateTime());
        DocumentClassifierDetailsHelper.setExpiresOn(classifierDetails, inner.getExpirationDateTime());
        return classifierDetails;
    }

    private static Map<String, com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails> fromInnerDocTypes(Map<String, ClassifierDocumentTypeDetails> innerDocTypes) {
        HashMap<String, com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails> documentTypeDetailsMap = new HashMap<String, com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails>();
        innerDocTypes.forEach((s, classifierDocumentTypeDetails) -> documentTypeDetailsMap.put((String)s, Transforms.fromInnerClassifierDetails(classifierDocumentTypeDetails)));
        return documentTypeDetailsMap;
    }

    private static com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails fromInnerClassifierDetails(ClassifierDocumentTypeDetails innerClassifier) {
        com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails classifierDocumentTypeDetails = null;
        if (innerClassifier.getAzureBlobSource() != null) {
            AzureBlobContentSource blobContentSource = innerClassifier.getAzureBlobSource();
            classifierDocumentTypeDetails = new com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails(new BlobContentSource(blobContentSource.getContainerUrl()).setPrefix(blobContentSource.getPrefix()));
        } else if (innerClassifier.getAzureBlobFileListSource() != null) {
            AzureBlobFileListContentSource listSource = innerClassifier.getAzureBlobFileListSource();
            classifierDocumentTypeDetails = new com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails(new BlobFileListContentSource(listSource.getContainerUrl(), listSource.getFileList()));
        }
        return classifierDocumentTypeDetails;
    }

    private static com.azure.ai.formrecognizer.documentanalysis.administration.models.QuotaDetails toQuotaDetails(QuotaDetails innerQuotaDetails) {
        com.azure.ai.formrecognizer.documentanalysis.administration.models.QuotaDetails quotaDetails = new com.azure.ai.formrecognizer.documentanalysis.administration.models.QuotaDetails();
        QuotaDetailsHelper.setUsed(quotaDetails, innerQuotaDetails.getUsed());
        QuotaDetailsHelper.setQuotaResetDateTime(quotaDetails, innerQuotaDetails.getQuotaResetDateTime());
        QuotaDetailsHelper.setQuota(quotaDetails, innerQuotaDetails.getQuota());
        return quotaDetails;
    }
}

