/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.models;

import com.azure.ai.formrecognizer.implementation.FormPageHelper;
import com.azure.ai.formrecognizer.models.FormLine;
import com.azure.ai.formrecognizer.models.FormSelectionMark;
import com.azure.ai.formrecognizer.models.FormTable;
import com.azure.ai.formrecognizer.models.LengthUnit;
import java.util.Collections;
import java.util.List;

public final class FormPage {
    private final float height;
    private final List<FormLine> lines;
    private final List<FormTable> tables;
    private List<FormSelectionMark> selectionMarks;
    private final float textAngle;
    private final LengthUnit unit;
    private final float width;
    private final Integer pageNumber;

    public FormPage(float height, float textAngle, LengthUnit unit, float width, List<FormLine> lines, List<FormTable> tables, int pageNumber) {
        this.height = height;
        this.textAngle = textAngle > 180.0f ? textAngle - 360.0f : textAngle;
        this.unit = unit;
        this.width = width;
        this.lines = lines == null ? null : Collections.unmodifiableList(lines);
        this.tables = tables == null ? null : Collections.unmodifiableList(tables);
        this.pageNumber = pageNumber;
    }

    public float getHeight() {
        return this.height;
    }

    public List<FormLine> getLines() {
        return this.lines;
    }

    public List<FormTable> getTables() {
        return this.tables;
    }

    public float getTextAngle() {
        return this.textAngle;
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public float getWidth() {
        return this.width;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public List<FormSelectionMark> getSelectionMarks() {
        return Collections.unmodifiableList(this.selectionMarks);
    }

    private void setSelectionMarks(List<FormSelectionMark> selectionMarks) {
        this.selectionMarks = selectionMarks;
    }

    static {
        FormPageHelper.setAccessor(new FormPageHelper.FormPageAccessor(){

            @Override
            public void setSelectionMarks(FormPage formPage, List<FormSelectionMark> selectionMarks) {
                formPage.setSelectionMarks(selectionMarks);
            }
        });
    }
}

