/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerToolEnvironment;
import com.azure.ai.openai.responses.models.ResponsesTool;
import com.azure.ai.openai.responses.models.ResponsesToolType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesComputerTool
extends ResponsesTool {
    private ResponsesToolType type = ResponsesToolType.COMPUTER;
    private final int displayWidth;
    private final int displayHeight;
    private final ResponsesComputerToolEnvironment environment;

    @Override
    public ResponsesToolType getType() {
        return this.type;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public ResponsesComputerToolEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("display_width", this.displayWidth);
        jsonWriter.writeIntField("display_height", this.displayHeight);
        jsonWriter.writeStringField("environment", this.environment == null ? null : this.environment.toString());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesComputerTool fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesComputerTool)jsonReader.readObject(reader -> {
            int displayWidth = 0;
            int displayHeight = 0;
            ResponsesComputerToolEnvironment environment = null;
            ResponsesToolType type = ResponsesToolType.COMPUTER;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("display_width".equals(fieldName)) {
                    displayWidth = reader.getInt();
                    continue;
                }
                if ("display_height".equals(fieldName)) {
                    displayHeight = reader.getInt();
                    continue;
                }
                if ("environment".equals(fieldName)) {
                    environment = ResponsesComputerToolEnvironment.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesToolType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesComputerTool deserializedResponsesComputerTool = new ResponsesComputerTool(displayWidth, displayHeight, environment);
            deserializedResponsesComputerTool.type = type;
            return deserializedResponsesComputerTool;
        });
    }

    public ResponsesComputerTool(int displayWidth, int displayHeight, ResponsesComputerToolEnvironment environment) {
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.environment = environment;
    }
}

