/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventRefusalDelta
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_REFUSAL_DELTA;
    private final String itemId;
    private final int outputIndex;
    private final int contentIndex;
    private final String delta;

    private ResponsesStreamEventRefusalDelta(String itemId, int outputIndex, int contentIndex, String delta) {
        this.itemId = itemId;
        this.outputIndex = outputIndex;
        this.contentIndex = contentIndex;
        this.delta = delta;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public int getContentIndex() {
        return this.contentIndex;
    }

    public String getDelta() {
        return this.delta;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("item_id", this.itemId);
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeIntField("content_index", this.contentIndex);
        jsonWriter.writeStringField("delta", this.delta);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventRefusalDelta fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventRefusalDelta)jsonReader.readObject(reader -> {
            String itemId = null;
            int outputIndex = 0;
            int contentIndex = 0;
            String delta = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_REFUSAL_DELTA;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("item_id".equals(fieldName)) {
                    itemId = reader.getString();
                    continue;
                }
                if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                    continue;
                }
                if ("content_index".equals(fieldName)) {
                    contentIndex = reader.getInt();
                    continue;
                }
                if ("delta".equals(fieldName)) {
                    delta = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventRefusalDelta deserializedResponsesStreamEventRefusalDelta = new ResponsesStreamEventRefusalDelta(itemId, outputIndex, contentIndex, delta);
            deserializedResponsesStreamEventRefusalDelta.type = type;
            return deserializedResponsesStreamEventRefusalDelta;
        });
    }
}

