/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.http.HttpClient;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.http.PlaybackClient;
import com.azure.core.test.http.TestProxyPlaybackClient;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.models.TestProxyRecordingOptions;
import com.azure.core.test.models.TestProxyRequestMatcher;
import com.azure.core.test.models.TestProxySanitizer;
import com.azure.core.test.policy.RecordNetworkCallPolicy;
import com.azure.core.test.policy.TestProxyRecordPolicy;
import com.azure.core.test.utils.TestUtils;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class InterceptorManager
implements AutoCloseable {
    private static final ObjectMapper RECORD_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final ClientLogger LOGGER = new ClientLogger(InterceptorManager.class);
    private final Map<String, String> textReplacementRules;
    private final String testName;
    private final String playbackRecordName;
    private final TestMode testMode;
    private final boolean allowedToReadRecordedValues;
    private final boolean allowedToRecordValues;
    private final RecordedData recordedData;
    private final boolean testProxyEnabled;
    private final boolean skipRecordingRequestBody;
    private TestProxyRecordPolicy testProxyRecordPolicy;
    private TestProxyPlaybackClient testProxyPlaybackClient;
    private final Queue<String> proxyVariableQueue = new LinkedList<String>();
    private HttpClient httpClient;
    private final Path testClassPath;
    private String xRecordingFileLocation;

    @Deprecated
    public InterceptorManager(String testName, TestMode testMode) {
        this(testName, testName, testMode, false, false, false, null);
    }

    public InterceptorManager(TestContextManager testContextManager) {
        this(testContextManager.getTestName(), testContextManager.getTestPlaybackRecordingName(), testContextManager.getTestMode(), testContextManager.doNotRecordTest(), testContextManager.isTestProxyEnabled(), testContextManager.skipRecordingRequestBody(), testContextManager.getTestClassPath());
    }

    private InterceptorManager(String testName, String playbackRecordName, TestMode testMode, boolean doNotRecord, boolean enableTestProxy, boolean skipRecordingRequestBody, Path testClassPath) {
        this.testProxyEnabled = enableTestProxy;
        Objects.requireNonNull(testName, "'testName' cannot be null.");
        this.testName = testName;
        this.playbackRecordName = CoreUtils.isNullOrEmpty((CharSequence)playbackRecordName) ? testName : playbackRecordName;
        this.testMode = testMode;
        this.textReplacementRules = new HashMap<String, String>();
        this.skipRecordingRequestBody = skipRecordingRequestBody;
        this.testClassPath = testClassPath;
        this.allowedToReadRecordedValues = testMode == TestMode.PLAYBACK && !doNotRecord;
        boolean bl = this.allowedToRecordValues = testMode == TestMode.RECORD && !doNotRecord;
        this.recordedData = !enableTestProxy && this.allowedToReadRecordedValues ? this.readDataFromFile() : (!enableTestProxy && this.allowedToRecordValues ? new RecordedData() : null);
    }

    @Deprecated
    public InterceptorManager(String testName, Map<String, String> textReplacementRules) {
        this(testName, textReplacementRules, false, testName);
    }

    @Deprecated
    public InterceptorManager(String testName, Map<String, String> textReplacementRules, boolean doNotRecord) {
        this(testName, textReplacementRules, doNotRecord, testName);
    }

    public InterceptorManager(String testName, Map<String, String> textReplacementRules, boolean doNotRecord, String playbackRecordName) {
        Objects.requireNonNull(testName, "'testName' cannot be null.");
        Objects.requireNonNull(textReplacementRules, "'textReplacementRules' cannot be null.");
        this.testName = testName;
        this.playbackRecordName = CoreUtils.isNullOrEmpty((CharSequence)playbackRecordName) ? testName : playbackRecordName;
        this.testMode = TestMode.PLAYBACK;
        this.allowedToReadRecordedValues = !doNotRecord;
        this.allowedToRecordValues = false;
        this.testProxyEnabled = false;
        this.skipRecordingRequestBody = false;
        this.testClassPath = null;
        this.recordedData = this.allowedToReadRecordedValues ? this.readDataFromFile() : null;
        this.textReplacementRules = textReplacementRules;
    }

    public boolean isPlaybackMode() {
        return this.testMode == TestMode.PLAYBACK;
    }

    public boolean isLiveMode() {
        return this.testMode == TestMode.LIVE;
    }

    public boolean isRecordMode() {
        return this.testMode == TestMode.RECORD;
    }

    public RecordedData getRecordedData() {
        return this.recordedData;
    }

    public Supplier<String> getProxyVariableSupplier() {
        return () -> {
            Objects.requireNonNull(this.testProxyPlaybackClient, "Playback must be started to retrieve values");
            if (!CoreUtils.isNullOrEmpty(this.proxyVariableQueue)) {
                return this.proxyVariableQueue.remove();
            }
            throw LOGGER.logExceptionAsError(new RuntimeException("'proxyVariableQueue' cannot be null or empty."));
        };
    }

    public Consumer<String> getProxyVariableConsumer() {
        return this.proxyVariableQueue::add;
    }

    public HttpPipelinePolicy getRecordPolicy() {
        if (this.testProxyEnabled) {
            return this.getProxyRecordingPolicy();
        }
        return this.getRecordPolicy(Collections.emptyList());
    }

    public HttpPipelinePolicy getRecordPolicy(List<Function<String, String>> recordingRedactors) {
        if (this.testProxyEnabled) {
            return this.getProxyRecordingPolicy();
        }
        return new RecordNetworkCallPolicy(this.recordedData, recordingRedactors);
    }

    public HttpClient getPlaybackClient() {
        if (this.testProxyEnabled) {
            if (!this.isPlaybackMode()) {
                throw new IllegalStateException("A playback client can only be requested in PLAYBACK mode.");
            }
            if (this.testProxyPlaybackClient == null) {
                this.testProxyPlaybackClient = new TestProxyPlaybackClient(this.httpClient, this.skipRecordingRequestBody);
                this.proxyVariableQueue.addAll(this.testProxyPlaybackClient.startPlayback(this.getTestProxyRecordFile(), this.testClassPath));
                this.xRecordingFileLocation = this.testProxyPlaybackClient.getRecordingFileLocation();
            }
            return this.testProxyPlaybackClient;
        }
        return new PlaybackClient(this.recordedData, this.textReplacementRules);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        if (this.allowedToRecordValues) {
            if (this.testProxyEnabled) {
                this.testProxyRecordPolicy.stopRecording(this.proxyVariableQueue);
                return;
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.createRecordFile(this.playbackRecordName).toPath(), new OpenOption[0]);){
                RECORD_MAPPER.writeValue((Writer)writer, (Object)this.recordedData);
                return;
            }
            catch (IOException ex) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException("Unable to write data to playback file.", ex));
            }
        }
        if (!this.isPlaybackMode() || !this.testProxyEnabled || !this.allowedToReadRecordedValues) return;
        this.testProxyPlaybackClient.stopPlayback();
    }

    private RecordedData readDataFromFile() {
        RecordedData recordedData;
        block8: {
            File recordFile = this.getRecordFile();
            BufferedReader reader = Files.newBufferedReader(recordFile.toPath());
            try {
                recordedData = (RecordedData)RECORD_MAPPER.readValue((Reader)reader, RecordedData.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw LOGGER.logExceptionAsWarning((RuntimeException)new UncheckedIOException(ex));
                }
            }
            reader.close();
        }
        return recordedData;
    }

    private HttpPipelinePolicy getProxyRecordingPolicy() {
        if (this.testProxyRecordPolicy == null) {
            if (!this.isRecordMode()) {
                throw new IllegalStateException("A recording policy can only be requested in RECORD mode.");
            }
            this.testProxyRecordPolicy = new TestProxyRecordPolicy(this.httpClient, this.skipRecordingRequestBody);
            this.testProxyRecordPolicy.startRecording(this.getTestProxyRecordFile(), this.testClassPath);
        }
        return this.testProxyRecordPolicy;
    }

    private File getTestProxyRecordFile() {
        Path repoRoot = TestUtils.getRepoRootResolveUntil(this.testClassPath, "eng");
        Path targetFolderRoot = TestUtils.getRepoRootResolveUntil(this.testClassPath, "target");
        Path filePath = Paths.get(targetFolderRoot.toString(), "src/test/resources/session-records", this.playbackRecordName + ".json");
        return repoRoot.relativize(filePath).toFile();
    }

    private File getRecordFile() {
        File recordFolder = TestUtils.getRecordFolder();
        File playbackFile = new File(recordFolder, this.playbackRecordName + ".json");
        File oldPlaybackFile = new File(recordFolder, this.testName + ".json");
        if (!playbackFile.exists() && !oldPlaybackFile.exists()) {
            throw LOGGER.logExceptionAsError(new RuntimeException(String.format("Missing both new and old playback files. Files are %s and %s.", playbackFile.getPath(), oldPlaybackFile.getPath())));
        }
        if (playbackFile.exists()) {
            LOGGER.info("==> Playback file path: {}", new Object[]{playbackFile.getPath()});
            return playbackFile;
        }
        LOGGER.info("==> Playback file path: {}", new Object[]{oldPlaybackFile.getPath()});
        return oldPlaybackFile;
    }

    private File createRecordFile(String testName) throws IOException {
        File recordFile;
        File recordFolder = TestUtils.getRecordFolder();
        if (!recordFolder.exists() && recordFolder.mkdir()) {
            LOGGER.verbose("Created directory: {}", new Object[]{recordFolder.getPath()});
        }
        if ((recordFile = new File(recordFolder, testName + ".json")).createNewFile()) {
            LOGGER.verbose("Created record file: {}", new Object[]{recordFile.getPath()});
        }
        LOGGER.info("==> Playback file path: " + recordFile);
        return recordFile;
    }

    public void addTextReplacementRule(String regex, String replacement) {
        this.textReplacementRules.put(regex, replacement);
    }

    public void addSanitizers(List<TestProxySanitizer> testProxySanitizers) {
        if (CoreUtils.isNullOrEmpty(testProxySanitizers)) {
            return;
        }
        if (this.testProxyPlaybackClient != null) {
            this.testProxyPlaybackClient.addProxySanitization(testProxySanitizers);
        } else if (this.testProxyRecordPolicy != null) {
            this.testProxyRecordPolicy.addProxySanitization(testProxySanitizers);
        } else {
            throw new RuntimeException("Playback or record must have been started before adding sanitizers.");
        }
    }

    public void addSanitizers(TestProxySanitizer ... testProxySanitizers) {
        if (testProxySanitizers != null) {
            this.addSanitizers(Arrays.asList(testProxySanitizers));
        }
    }

    public void addMatchers(List<TestProxyRequestMatcher> testProxyMatchers) {
        if (CoreUtils.isNullOrEmpty(testProxyMatchers)) {
            return;
        }
        if (this.testMode != TestMode.PLAYBACK) {
            return;
        }
        if (this.testProxyPlaybackClient == null) {
            throw new RuntimeException("Playback must have been started before adding matchers.");
        }
        this.testProxyPlaybackClient.addMatcherRequests(testProxyMatchers);
    }

    public void addMatchers(TestProxyRequestMatcher ... testProxyRequestMatchers) {
        if (testProxyRequestMatchers != null) {
            this.addMatchers(Arrays.asList(testProxyRequestMatchers));
        }
    }

    public String getRecordingFileLocation() {
        return this.xRecordingFileLocation;
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setProxyRecordingOptions(TestProxyRecordingOptions testProxyRecordingOptions) {
        if (this.testMode != TestMode.RECORD) {
            return;
        }
        if (this.testProxyRecordPolicy == null) {
            throw new RuntimeException("Recording must have been started before setting recording options.");
        }
        this.testProxyRecordPolicy.setRecordingOptions(testProxyRecordingOptions);
    }

    public String getTestName() {
        return this.testName;
    }

    public String getPlaybackRecordName() {
        return this.playbackRecordName;
    }
}

