/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;

public final class ReflectionSerializable {
    private static final ClientLogger LOGGER = new ClientLogger(ReflectionSerializable.class);
    private static final Map<Class<?>, ReflectiveInvoker> FROM_JSON_CACHE = new ConcurrentHashMap();
    private static final Class<?> XML_SERIALIZABLE;
    private static final Class<?> XML_READER;
    private static final ReflectiveInvoker XML_READER_CREATOR;
    private static final ReflectiveInvoker XML_WRITER_CREATOR;
    private static final ReflectiveInvoker XML_WRITER_WRITE_XML_START_DOCUMENT;
    private static final ReflectiveInvoker XML_WRITER_WRITE_XML_SERIALIZABLE;
    private static final ReflectiveInvoker XML_WRITER_FLUSH;
    static final boolean XML_SERIALIZABLE_SUPPORTED;
    private static final Map<Class<?>, ReflectiveInvoker> FROM_XML_CACHE;

    public static boolean supportsJsonSerializable(Class<?> bodyContentClass) {
        return JsonSerializable.class.isAssignableFrom(bodyContentClass);
    }

    public static ByteBuffer serializeJsonSerializableToByteBuffer(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, AccessibleByteArrayOutputStream::toByteBuffer);
    }

    public static byte[] serializeJsonSerializableToBytes(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, AccessibleByteArrayOutputStream::toByteArray);
    }

    public static String serializeJsonSerializableToString(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, aos -> aos.toString(StandardCharsets.UTF_8));
    }

    private static <T> T serializeJsonSerializableWithReturn(JsonSerializable<?> jsonSerializable, Function<AccessibleByteArrayOutputStream, T> returner) throws IOException {
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();){
            T t;
            block11: {
                JsonWriter jsonWriter = JsonProviders.createWriter((OutputStream)outputStream);
                try {
                    jsonWriter.writeJson(jsonSerializable).flush();
                    t = returner.apply(outputStream);
                    if (jsonWriter == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return t;
        }
    }

    public static void serializeJsonSerializableIntoOutputStream(JsonSerializable<?> jsonSerializable, OutputStream outputStream) throws IOException {
        try (JsonWriter jsonWriter = JsonProviders.createWriter((OutputStream)outputStream);){
            jsonWriter.writeJson(jsonSerializable).flush();
        }
    }

    public static Object deserializeAsJsonSerializable(Class<?> jsonSerializable, byte[] json) throws IOException {
        Object object;
        block11: {
            if (FROM_JSON_CACHE.size() >= 10000) {
                FROM_JSON_CACHE.clear();
            }
            ReflectiveInvoker readJson = FROM_JSON_CACHE.computeIfAbsent(jsonSerializable, clazz -> {
                try {
                    return ReflectionUtils.getMethodInvoker(clazz, jsonSerializable.getDeclaredMethod("fromJson", JsonReader.class));
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(e));
                }
            });
            JsonReader jsonReader = JsonProviders.createReader((byte[])json);
            try {
                object = readJson.invokeStatic(jsonReader);
                if (jsonReader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Exception) {
                        throw new IOException(e);
                    }
                    throw (Error)e;
                }
            }
            jsonReader.close();
        }
        return object;
    }

    public static boolean supportsXmlSerializable(Class<?> bodyContentClass) {
        return XML_SERIALIZABLE_SUPPORTED && XML_SERIALIZABLE.isAssignableFrom(bodyContentClass);
    }

    public static ByteBuffer serializeXmlSerializableToByteBuffer(Object xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, AccessibleByteArrayOutputStream::toByteBuffer);
    }

    public static byte[] serializeXmlSerializableToBytes(Object xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, AccessibleByteArrayOutputStream::toByteArray);
    }

    public static String serializeXmlSerializableToString(Object xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, aos -> aos.toString(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <T> T serializeXmlSerializableWithReturn(Object xmlSerializable, Function<AccessibleByteArrayOutputStream, T> returner) throws IOException {
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();){
            AccessibleByteArrayOutputStream accessibleByteArrayOutputStream;
            block14: {
                AutoCloseable xmlWriter = ReflectionSerializable.callXmlInvoker(AutoCloseable.class, () -> XML_WRITER_CREATOR.invokeStatic(outputStream));
                try {
                    ReflectionSerializable.callXmlInvoker(Object.class, () -> XML_WRITER_WRITE_XML_START_DOCUMENT.invokeWithArguments(xmlWriter, new Object[0]));
                    ReflectionSerializable.callXmlInvoker(Object.class, () -> XML_WRITER_WRITE_XML_SERIALIZABLE.invokeWithArguments(xmlWriter, xmlSerializable));
                    ReflectionSerializable.callXmlInvoker(Object.class, () -> XML_WRITER_FLUSH.invokeWithArguments(xmlWriter, new Object[0]));
                    accessibleByteArrayOutputStream = returner.apply(outputStream);
                    if (xmlWriter == null) break block14;
                }
                catch (Throwable throwable) {
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                xmlWriter.close();
            }
            return (T)accessibleByteArrayOutputStream;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static void serializeXmlSerializableIntoOutputStream(Object xmlSerializable, OutputStream outputStream) throws IOException {
        try (AutoCloseable xmlWriter = ReflectionSerializable.callXmlInvoker(AutoCloseable.class, () -> XML_WRITER_CREATOR.invokeStatic(outputStream));){
            ReflectionSerializable.callXmlInvoker(Object.class, () -> XML_WRITER_WRITE_XML_START_DOCUMENT.invokeWithArguments(xmlWriter, new Object[0]));
            ReflectionSerializable.callXmlInvoker(Object.class, () -> XML_WRITER_WRITE_XML_SERIALIZABLE.invokeWithArguments(xmlWriter, xmlSerializable));
            ReflectionSerializable.callXmlInvoker(Object.class, () -> XML_WRITER_FLUSH.invokeWithArguments(xmlWriter, new Object[0]));
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static Object deserializeAsXmlSerializable(Class<?> xmlSerializable, byte[] xml) throws IOException {
        Object object;
        block12: {
            if (!XML_SERIALIZABLE_SUPPORTED) {
                return null;
            }
            if (FROM_XML_CACHE.size() >= 10000) {
                FROM_XML_CACHE.clear();
            }
            ReflectiveInvoker readXml = FROM_XML_CACHE.computeIfAbsent(xmlSerializable, clazz -> {
                try {
                    return ReflectionUtils.getMethodInvoker(xmlSerializable, xmlSerializable.getDeclaredMethod("fromXml", XML_READER));
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(e));
                }
            });
            AutoCloseable xmlReader = ReflectionSerializable.callXmlInvoker(AutoCloseable.class, () -> XML_READER_CREATOR.invokeStatic(new Object[]{xml}));
            try {
                object = readXml.invokeStatic(xmlReader);
                if (xmlReader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Exception) {
                        throw new IOException(e);
                    }
                    throw (Error)e;
                }
            }
            xmlReader.close();
        }
        return object;
    }

    private static <T> T callXmlInvoker(Class<T> returnType, Callable<Object> invoker) throws XMLStreamException {
        try {
            return returnType.cast(invoker.call());
        }
        catch (Exception exception) {
            if (exception instanceof XMLStreamException) {
                throw (XMLStreamException)exception;
            }
            throw new XMLStreamException(exception);
        }
    }

    private ReflectionSerializable() {
    }

    static {
        Class<?> xmlSerializable = null;
        Class<?> xmlReader = null;
        ReflectiveInvoker xmlReaderCreator = null;
        ReflectiveInvoker xmlWriterCreator = null;
        ReflectiveInvoker xmlWriterWriteStartDocument = null;
        ReflectiveInvoker xmlWriterWriteXmlSerializable = null;
        ReflectiveInvoker xmlWriterFlush = null;
        boolean xmlSerializableSupported = false;
        try {
            xmlSerializable = Class.forName("com.azure.xml.XmlSerializable");
            xmlReader = Class.forName("com.azure.xml.XmlReader");
            Class<?> xmlProviders = Class.forName("com.azure.xml.XmlProviders");
            xmlReaderCreator = ReflectionUtils.getMethodInvoker(xmlProviders, xmlProviders.getDeclaredMethod("createReader", byte[].class));
            xmlWriterCreator = ReflectionUtils.getMethodInvoker(xmlProviders, xmlProviders.getDeclaredMethod("createWriter", OutputStream.class));
            Class<?> xmlWriter = Class.forName("com.azure.xml.XmlWriter");
            xmlWriterWriteStartDocument = ReflectionUtils.getMethodInvoker(xmlWriter, xmlWriter.getDeclaredMethod("writeStartDocument", new Class[0]));
            xmlWriterWriteXmlSerializable = ReflectionUtils.getMethodInvoker(xmlWriter, xmlWriter.getDeclaredMethod("writeXml", xmlSerializable));
            xmlWriterFlush = ReflectionUtils.getMethodInvoker(xmlWriter, xmlWriter.getDeclaredMethod("flush", new Class[0]));
            xmlSerializableSupported = true;
        }
        catch (Throwable e) {
            if (e instanceof LinkageError || e instanceof Exception) {
                LOGGER.log(LogLevel.VERBOSE, () -> "XmlSerializable serialization and deserialization isn't supported. If it is required add a dependency of 'com.azure:azure-xml', or another dependencies which include 'com.azure:azure-xml' as a transitive dependency. If your application runs as expected this informational message can be ignored.", e);
            }
            throw (Error)e;
        }
        XML_SERIALIZABLE = xmlSerializable;
        XML_READER = xmlReader;
        XML_READER_CREATOR = xmlReaderCreator;
        XML_WRITER_CREATOR = xmlWriterCreator;
        XML_WRITER_WRITE_XML_START_DOCUMENT = xmlWriterWriteStartDocument;
        XML_WRITER_WRITE_XML_SERIALIZABLE = xmlWriterWriteXmlSerializable;
        XML_WRITER_FLUSH = xmlWriterFlush;
        XML_SERIALIZABLE_SUPPORTED = xmlSerializableSupported;
        FROM_XML_CACHE = XML_SERIALIZABLE_SUPPORTED ? new ConcurrentHashMap() : null;
    }
}

