/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.ObjectNodeMap;
import com.azure.cosmos.implementation.PrimitiveJsonNodeMap;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;

public abstract class CosmosItemSerializer {
    private static final ObjectMapper objectMapper = Utils.getSimpleObjectMapper();
    public static final CosmosItemSerializer DEFAULT_SERIALIZER = new DefaultCosmosItemSerializer();

    protected CosmosItemSerializer() {
    }

    public abstract <T> Map<String, Object> serialize(T var1);

    public abstract <T> T deserialize(Map<String, Object> var1, Class<T> var2);

    private static class DefaultCosmosItemSerializer
    extends CosmosItemSerializer {
        DefaultCosmosItemSerializer() {
        }

        @Override
        public <T> Map<String, Object> serialize(T item) {
            if (item == null) {
                return null;
            }
            if (item instanceof ObjectNode) {
                return new ObjectNodeMap((ObjectNode)item);
            }
            if (item instanceof JsonSerializable) {
                return ((JsonSerializable)item).getMap();
            }
            JsonNode jsonNode = (JsonNode)objectMapper.convertValue(item, JsonNode.class);
            if (jsonNode == null) {
                return null;
            }
            if (jsonNode.isObject()) {
                return new ObjectNodeMap((ObjectNode)jsonNode);
            }
            return new PrimitiveJsonNodeMap(jsonNode);
        }

        @Override
        public <T> T deserialize(Map<String, Object> jsonNodeMap, Class<T> classType) {
            if (jsonNodeMap == null) {
                return null;
            }
            ObjectNode jsonNode = null;
            try {
                if (jsonNodeMap instanceof ObjectNodeMap) {
                    jsonNode = ((ObjectNodeMap)jsonNodeMap).getObjectNode();
                } else {
                    if (jsonNodeMap instanceof PrimitiveJsonNodeMap) {
                        return (T)objectMapper.convertValue((Object)((PrimitiveJsonNodeMap)jsonNodeMap).getPrimitiveJsonNode(), classType);
                    }
                    jsonNode = (ObjectNode)objectMapper.convertValue(jsonNodeMap, ObjectNode.class);
                }
                if (JsonSerializable.class.isAssignableFrom(classType)) {
                    return (T)JsonSerializable.instantiateFromObjectNodeAndType(jsonNode, classType);
                }
                return (T)objectMapper.treeToValue((TreeNode)jsonNode, classType);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to parse JSON %s as %s", jsonNode, classType.getName()), e);
            }
        }
    }
}

