/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosDiagnosticsThresholds;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RequestOptions;
import com.azure.cosmos.implementation.apachecommons.collections.list.UnmodifiableList;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.DedicatedGatewayRequestOptions;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class CosmosQueryRequestOptionsBase<T extends CosmosQueryRequestOptionsBase<?>> {
    private static final ImplementationBridgeHelpers.CosmosDiagnosticsThresholdsHelper.CosmosDiagnosticsThresholdsAccessor thresholdsAccessor = ImplementationBridgeHelpers.CosmosDiagnosticsThresholdsHelper.getCosmosAsyncClientAccessor();
    private ConsistencyLevel consistencyLevel;
    private String sessionToken;
    private int responseContinuationTokenLimitInKb;
    private boolean queryMetricsEnabled;
    private Map<String, Object> properties;
    private OperationContextAndListenerTuple operationContextAndListenerTuple;
    private String throughputControlGroupName;
    private DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions;
    private CosmosDiagnosticsThresholds thresholds;
    private Map<String, String> customOptions;
    private boolean indexMetricsEnabled;
    private UUID correlationActivityId;
    private CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig;
    private List<String> excludeRegions;
    private CosmosItemSerializer customSerializer;

    protected CosmosQueryRequestOptionsBase() {
        this.thresholds = null;
        this.queryMetricsEnabled = true;
    }

    protected CosmosQueryRequestOptionsBase(CosmosQueryRequestOptionsBase<?> options) {
        this.consistencyLevel = options.consistencyLevel;
        this.sessionToken = options.sessionToken;
        this.responseContinuationTokenLimitInKb = options.responseContinuationTokenLimitInKb;
        this.queryMetricsEnabled = options.queryMetricsEnabled;
        this.throughputControlGroupName = options.throughputControlGroupName;
        this.operationContextAndListenerTuple = options.operationContextAndListenerTuple;
        this.dedicatedGatewayRequestOptions = options.dedicatedGatewayRequestOptions;
        this.customOptions = options.customOptions;
        this.indexMetricsEnabled = options.indexMetricsEnabled;
        this.correlationActivityId = options.correlationActivityId;
        this.thresholds = options.thresholds;
        this.cosmosEndToEndOperationLatencyPolicyConfig = options.cosmosEndToEndOperationLatencyPolicyConfig;
        this.excludeRegions = options.excludeRegions;
        this.properties = options.properties;
        this.customSerializer = options.customSerializer;
    }

    public void setOperationContextAndListenerTuple(OperationContextAndListenerTuple operationContextAndListenerTuple) {
        this.operationContextAndListenerTuple = operationContextAndListenerTuple;
    }

    public OperationContextAndListenerTuple getOperationContextAndListenerTuple() {
        return this.operationContextAndListenerTuple;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public T setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return (T)this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public T setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return (T)this;
    }

    public UUID getCorrelationActivityId() {
        return this.correlationActivityId;
    }

    public T setCorrelationActivityId(UUID correlationActivityId) {
        this.correlationActivityId = correlationActivityId;
        return (T)this;
    }

    public T setResponseContinuationTokenLimitInKb(int limitInKb) {
        this.responseContinuationTokenLimitInKb = limitInKb;
        return (T)this;
    }

    public int getResponseContinuationTokenLimitInKb() {
        return this.responseContinuationTokenLimitInKb;
    }

    public T setCosmosEndToEndOperationLatencyPolicyConfig(CosmosEndToEndOperationLatencyPolicyConfig cosmosEndToEndOperationLatencyPolicyConfig) {
        this.cosmosEndToEndOperationLatencyPolicyConfig = cosmosEndToEndOperationLatencyPolicyConfig;
        return (T)this;
    }

    public T setExcludedRegions(List<String> excludeRegions) {
        this.excludeRegions = excludeRegions;
        return (T)this;
    }

    public List<String> getExcludedRegions() {
        if (this.excludeRegions == null) {
            return null;
        }
        return UnmodifiableList.unmodifiableList(this.excludeRegions);
    }

    public boolean isQueryMetricsEnabled() {
        return this.queryMetricsEnabled;
    }

    public T setQueryMetricsEnabled(boolean queryMetricsEnabled) {
        this.queryMetricsEnabled = queryMetricsEnabled;
        return (T)this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public T setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return (T)this;
    }

    public String getThroughputControlGroupName() {
        return this.throughputControlGroupName;
    }

    public T setThroughputControlGroupName(String throughputControlGroupName) {
        this.throughputControlGroupName = throughputControlGroupName;
        return (T)this;
    }

    public DedicatedGatewayRequestOptions getDedicatedGatewayRequestOptions() {
        return this.dedicatedGatewayRequestOptions;
    }

    public T setDedicatedGatewayRequestOptions(DedicatedGatewayRequestOptions dedicatedGatewayRequestOptions) {
        this.dedicatedGatewayRequestOptions = dedicatedGatewayRequestOptions;
        return (T)this;
    }

    public Duration getThresholdForDiagnosticsOnTracer() {
        if (this.thresholds == null) {
            return CosmosDiagnosticsThresholds.DEFAULT_NON_POINT_OPERATION_LATENCY_THRESHOLD;
        }
        return thresholdsAccessor.getNonPointReadLatencyThreshold(this.thresholds);
    }

    public T setThresholdForDiagnosticsOnTracer(Duration thresholdForDiagnosticsOnTracer) {
        if (this.thresholds == null) {
            this.thresholds = new CosmosDiagnosticsThresholds();
        }
        this.thresholds.setNonPointOperationLatencyThreshold(thresholdForDiagnosticsOnTracer);
        return (T)this;
    }

    public T setDiagnosticsThresholds(CosmosDiagnosticsThresholds operationSpecificThresholds) {
        this.thresholds = operationSpecificThresholds;
        return (T)this;
    }

    public boolean isIndexMetricsEnabled() {
        return this.indexMetricsEnabled;
    }

    public T setIndexMetricsEnabled(boolean indexMetricsEnabled) {
        this.indexMetricsEnabled = indexMetricsEnabled;
        return (T)this;
    }

    public T setHeader(String name, String value) {
        if (this.customOptions == null) {
            this.customOptions = new HashMap<String, String>();
        }
        this.customOptions.put(name, value);
        return (T)this;
    }

    public Map<String, String> getHeaders() {
        return this.customOptions;
    }

    public CosmosDiagnosticsThresholds getThresholds() {
        return this.thresholds;
    }

    public CosmosEndToEndOperationLatencyPolicyConfig getEndToEndOperationLatencyConfig() {
        return this.cosmosEndToEndOperationLatencyPolicyConfig;
    }

    public CosmosItemSerializer getCustomItemSerializer() {
        return this.customSerializer;
    }

    public T setCustomItemSerializer(CosmosItemSerializer customItemSerializer) {
        this.customSerializer = customItemSerializer;
        return (T)this;
    }

    public RequestOptions applyToRequestOptions(RequestOptions requestOptions) {
        requestOptions.setConsistencyLevel(this.getConsistencyLevel());
        requestOptions.setSessionToken(this.getSessionToken());
        requestOptions.setThroughputControlGroupName(this.getThroughputControlGroupName());
        requestOptions.setOperationContextAndListenerTuple(this.getOperationContextAndListenerTuple());
        requestOptions.setDedicatedGatewayRequestOptions(this.getDedicatedGatewayRequestOptions());
        if (this.thresholds != null) {
            requestOptions.setDiagnosticsThresholds(this.thresholds);
        }
        requestOptions.setCosmosEndToEndLatencyPolicyConfig(this.cosmosEndToEndOperationLatencyPolicyConfig);
        requestOptions.setExcludeRegions(this.excludeRegions);
        if (this.customOptions != null) {
            for (Map.Entry<String, String> entry : this.customOptions.entrySet()) {
                requestOptions.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return requestOptions;
    }
}

