/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.batch;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.ThrottlingRetryOptions;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ResourceThrottleRetryPolicy;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.batch.BulkOperationRetryPolicy;
import com.azure.cosmos.implementation.batch.ItemBulkOperation;
import com.azure.cosmos.implementation.batch.PartitionKeyRangeServerBatchRequest;
import com.azure.cosmos.implementation.batch.ServerOperationBatchRequest;
import com.azure.cosmos.implementation.caches.RxClientCollectionCache;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.PartitionKeyInternalHelper;
import com.azure.cosmos.models.CosmosBatchOperationResult;
import com.azure.cosmos.models.CosmosItemOperation;
import com.azure.cosmos.models.CosmosItemOperationType;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.PartitionKeyDefinition;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

final class BulkExecutorUtil {
    BulkExecutorUtil() {
    }

    static ServerOperationBatchRequest createBatchRequest(List<CosmosItemOperation> operations, String partitionKeyRangeId, int maxMicroBatchPayloadSizeInBytes, CosmosItemSerializer clientItemSerializer) {
        return PartitionKeyRangeServerBatchRequest.createBatchRequest(partitionKeyRangeId, operations, maxMicroBatchPayloadSizeInBytes, Math.min(operations.size(), 100), clientItemSerializer);
    }

    static void setRetryPolicyForBulk(AsyncDocumentClient docClientWrapper, CosmosAsyncContainer container, CosmosItemOperation cosmosItemOperation, ThrottlingRetryOptions throttlingRetryOptions) {
        if (!(cosmosItemOperation instanceof ItemBulkOperation)) {
            throw new UnsupportedOperationException("Unknown CosmosItemOperation.");
        }
        ItemBulkOperation itemBulkOperation = (ItemBulkOperation)cosmosItemOperation;
        ResourceThrottleRetryPolicy resourceThrottleRetryPolicy = new ResourceThrottleRetryPolicy(throttlingRetryOptions.getMaxRetryAttemptsOnThrottledRequests(), throttlingRetryOptions.getMaxRetryWaitTime(), true);
        BulkOperationRetryPolicy bulkRetryPolicy = new BulkOperationRetryPolicy(docClientWrapper.getCollectionCache(), docClientWrapper.getPartitionKeyRangeCache(), BridgeInternal.getLink(container), resourceThrottleRetryPolicy);
        itemBulkOperation.setRetryPolicy(bulkRetryPolicy);
    }

    static Map<String, String> getResponseHeadersFromBatchOperationResult(CosmosBatchOperationResult result) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-substatus", String.valueOf(result.getSubStatusCode()));
        headers.put("etag", result.getETag());
        headers.put("x-ms-request-charge", String.valueOf(result.getRequestCharge()));
        if (result.getRetryAfterDuration() != null) {
            headers.put("x-ms-retry-after-ms", String.valueOf(result.getRetryAfterDuration().toMillis()));
        }
        return headers;
    }

    static Mono<String> resolvePartitionKeyRangeId(AsyncDocumentClient docClientWrapper, CosmosAsyncContainer container, CosmosItemOperation operation) {
        Preconditions.checkNotNull(operation, "expected non-null operation");
        AtomicReference<Object> collectionBeforeRecreation = new AtomicReference<Object>(null);
        if (operation instanceof ItemBulkOperation) {
            ItemBulkOperation itemBulkOperation = (ItemBulkOperation)operation;
            Mono pkRangeIdMono = Mono.defer(() -> BulkExecutorUtil.getCollectionInfoAsync(docClientWrapper, container, (DocumentCollection)collectionBeforeRecreation.get()).flatMap(collection -> {
                PartitionKeyDefinition definition = collection.getPartitionKey();
                PartitionKeyInternal partitionKeyInternal = BulkExecutorUtil.getPartitionKeyInternal(operation, definition);
                itemBulkOperation.setPartitionKeyJson(partitionKeyInternal.toJson());
                return docClientWrapper.getPartitionKeyRangeCache().tryLookupAsync(null, collection.getResourceId(), null, null).map(routingMap -> {
                    if (routingMap.v == null) {
                        collectionBeforeRecreation.set(collection);
                        throw new CollectionRoutingMapNotFoundException(String.format("No collection routing map found for container %s(%s) in database %s.", container.getId(), collection.getResourceId(), container.getDatabase().getId()));
                    }
                    return ((CollectionRoutingMap)routingMap.v).getRangeByEffectivePartitionKey(PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKeyInternal, definition)).getId();
                });
            })).retryWhen((Retry)Retry.fixedDelay((long)10L, (Duration)Duration.ofSeconds(1L)).filter(t -> t instanceof CollectionRoutingMapNotFoundException).doBeforeRetry(retrySignal -> docClientWrapper.getCollectionCache().refresh(null, Utils.getCollectionName(BridgeInternal.getLink(container)), null)));
            return pkRangeIdMono;
        }
        throw new UnsupportedOperationException("Unknown CosmosItemOperation.");
    }

    private static PartitionKeyInternal getPartitionKeyInternal(CosmosItemOperation operation, PartitionKeyDefinition partitionKeyDefinition) {
        Preconditions.checkNotNull(operation, "expected non-null operation");
        PartitionKey partitionKey = operation.getPartitionKeyValue();
        if (partitionKey == null) {
            return ModelBridgeInternal.getNonePartitionKey(partitionKeyDefinition);
        }
        return BridgeInternal.getPartitionKeyInternal(partitionKey);
    }

    private static Mono<DocumentCollection> getCollectionInfoAsync(AsyncDocumentClient documentClient, CosmosAsyncContainer container, DocumentCollection obsoleteValue) {
        String resourceAddress = Utils.joinPath(BridgeInternal.getLink(container), null);
        RxClientCollectionCache clientCollectionCache = documentClient.getCollectionCache();
        return clientCollectionCache.resolveByNameAsync(null, resourceAddress, null, obsoleteValue);
    }

    static boolean isWriteOperation(CosmosItemOperationType cosmosItemOperationType) {
        return cosmosItemOperationType == CosmosItemOperationType.CREATE || cosmosItemOperationType == CosmosItemOperationType.REPLACE || cosmosItemOperationType == CosmosItemOperationType.UPSERT || cosmosItemOperationType == CosmosItemOperationType.DELETE || cosmosItemOperationType == CosmosItemOperationType.PATCH;
    }

    static class CollectionRoutingMapNotFoundException
    extends CosmosException {
        private static final long serialVersionUID = 1L;

        public CollectionRoutingMapNotFoundException(String msg) {
            super(404, msg);
            this.setSubStatus();
        }

        private void setSubStatus() {
            this.getResponseHeaders().put("x-ms-substatus", Integer.toString(1024));
        }
    }
}

