/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromTypes;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Instant;

class ChangeFeedStartFromPointInTimeImpl
extends ChangeFeedStartFromInternal {
    private final Instant pointInTime;

    public ChangeFeedStartFromPointInTimeImpl(Instant pointInTime) {
        if (pointInTime == null) {
            throw new NullPointerException("pointInTime");
        }
        this.pointInTime = pointInTime;
    }

    public Instant getPointInTime() {
        return this.pointInTime;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ChangeFeedStartFromPointInTimeImpl)) {
            return false;
        }
        ChangeFeedStartFromPointInTimeImpl otherStartFrom = (ChangeFeedStartFromPointInTimeImpl)obj;
        return this.pointInTime.equals(otherStartFrom.pointInTime);
    }

    @Override
    public int hashCode() {
        return this.pointInTime.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        ChangeFeedStartFromPointInTimeImpl changeFeedStartFromPointInTimeImpl = this;
        synchronized (changeFeedStartFromPointInTimeImpl) {
            this.set("Type", ChangeFeedStartFromTypes.POINT_IN_TIME, CosmosItemSerializer.DEFAULT_SERIALIZER);
            this.set("PointInTimeMs", this.pointInTime.toEpochMilli(), CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
    }

    @Override
    public void populateRequest(RxDocumentServiceRequest request, ChangeFeedMode changeFeedMode) {
        Preconditions.checkNotNull(request, "Argument 'request' must not be null.");
        Instant pointInTime = this.getPointInTime();
        if (pointInTime != START_FROM_BEGINNING_TIME) {
            request.getHeaders().put("If-Modified-Since", Utils.instantAsUTCRFC1123(pointInTime));
        }
    }

    @Override
    public boolean supportsFullFidelityRetention() {
        return false;
    }
}

