/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.guava27.Strings;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class RntbdThreadFactory
implements ThreadFactory {
    private static final String NAME_TEMPLATE = "cosmos-rntbd-%s[%s]";
    private final boolean daemon;
    private final String name;
    private final int priority;
    private final AtomicInteger threadCount;

    RntbdThreadFactory(String name, boolean daemon, int priority) {
        this.daemon = daemon;
        this.name = name;
        this.priority = priority;
        this.threadCount = new AtomicInteger();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = Strings.lenientFormat(NAME_TEMPLATE, this.name, this.threadCount.incrementAndGet());
        Thread thread = new Thread(runnable, name);
        if (thread.isDaemon() != this.daemon) {
            thread.setDaemon(this.daemon);
        }
        if (thread.getPriority() != this.priority) {
            thread.setPriority(this.priority);
        }
        return thread;
    }
}

