/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConstants;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdToken;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdTokenType;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava27.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.ReferenceCounted;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

abstract class RntbdTokenStream<T extends Enum<T>>
implements ReferenceCounted {
    final ByteBuf in;
    final Map<Short, T> headers;
    final EnumMap<T, RntbdToken> tokens;

    RntbdTokenStream(EnumSet<T> headers, Map<Short, T> ids, ByteBuf in, Class<T> classType) {
        Preconditions.checkNotNull(headers, "expected non-null headers");
        Preconditions.checkNotNull(ids, "expected non-null ids");
        Preconditions.checkNotNull(in, "expected non-null in");
        this.tokens = new EnumMap(classType);
        headers.stream().forEach(h -> this.tokens.put(h, RntbdToken.create((RntbdConstants.RntbdHeader)((Object)h))));
        this.headers = ids;
        this.in = in;
    }

    final int computeCount() {
        int count = 0;
        for (RntbdToken token : this.tokens.values()) {
            if (!token.isPresent()) continue;
            ++count;
        }
        return count;
    }

    final int computeLength() {
        int total = 0;
        for (RntbdToken token : this.tokens.values()) {
            total += token.computeLength();
        }
        return total;
    }

    static <T extends RntbdTokenStream<?>> T decode(T stream) {
        ByteBuf in = stream.in;
        while (in.readableBytes() > 0) {
            short id = in.readShortLE();
            RntbdTokenType type = RntbdTokenType.fromId(in.readByte());
            RntbdToken token = stream.tokens.get(stream.headers.get(id));
            if (token == null) {
                token = RntbdToken.create(new UndefinedHeader(id, type));
            }
            token.decode(in);
        }
        for (RntbdToken token : stream.tokens.values()) {
            if (token.isPresent() || !token.isRequired()) continue;
            String message = Strings.lenientFormat("Required header not found on token stream: %s", token);
            throw new CorruptedFrameException(message);
        }
        return stream;
    }

    final void encode(ByteBuf out) {
        for (RntbdToken token : this.tokens.values()) {
            token.encode(out);
        }
    }

    final RntbdToken get(T header) {
        return this.tokens.get(header);
    }

    public final int refCnt() {
        return this.in.refCnt();
    }

    public final boolean release() {
        return this.release(1);
    }

    public final boolean release(int count) {
        return this.in.release(count);
    }

    public final RntbdTokenStream<T> retain() {
        return this.retain(1);
    }

    public final RntbdTokenStream<T> retain(int count) {
        this.in.retain(count);
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    public ReferenceCounted touch() {
        return this;
    }

    private static final class UndefinedHeader
    implements RntbdConstants.RntbdHeader {
        private final short id;
        private final RntbdTokenType type;

        UndefinedHeader(short id, RntbdTokenType type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public String name() {
            return "Undefined";
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }
    }
}

