/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.models.UniqueKey;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;

public final class UniqueKeyPolicy {
    private List<UniqueKey> uniqueKeys;
    private JsonSerializable jsonSerializable;

    public UniqueKeyPolicy() {
        this.jsonSerializable = new JsonSerializable();
    }

    UniqueKeyPolicy(String jsonString) {
        this.jsonSerializable = new JsonSerializable(jsonString);
    }

    UniqueKeyPolicy(ObjectNode objectNode) {
        this.jsonSerializable = new JsonSerializable(objectNode);
    }

    public List<UniqueKey> getUniqueKeys() {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = this.jsonSerializable.getList("uniqueKeys", UniqueKey.class, new boolean[0]);
            if (this.uniqueKeys == null) {
                this.uniqueKeys = new ArrayList<UniqueKey>();
            }
        }
        return this.uniqueKeys;
    }

    public UniqueKeyPolicy setUniqueKeys(List<UniqueKey> uniqueKeys) {
        if (uniqueKeys == null) {
            throw new IllegalArgumentException("uniqueKeys cannot be null.");
        }
        this.uniqueKeys = uniqueKeys;
        return this;
    }

    void populatePropertyBag() {
        this.jsonSerializable.populatePropertyBag();
        if (this.uniqueKeys != null) {
            for (UniqueKey uniqueKey : this.uniqueKeys) {
                uniqueKey.populatePropertyBag();
            }
            this.jsonSerializable.set("uniqueKeys", this.uniqueKeys, CosmosItemSerializer.DEFAULT_SERIALIZER);
        }
    }

    JsonSerializable getJsonSerializable() {
        return this.jsonSerializable;
    }
}

