/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosDiagnosticsRequestEvent;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;

public final class CosmosDiagnosticsRequestInfo {
    private final String activityId;
    private final String partitionId;
    private final String partitionKeyRangeId;
    private final String requestType;
    private final Instant startTime;
    private final Duration duration;
    private final Duration backendLatency;
    private final Collection<CosmosDiagnosticsRequestEvent> events;

    CosmosDiagnosticsRequestInfo(String activityId, String partitionId, String partitionKeyRangeId, String requestType, Instant startTime, Duration duration, Duration backendLatency, double requestCharge, int responsePayloadSizeInBytes, int statusCode, int subStatusCode, Collection<CosmosDiagnosticsRequestEvent> events) {
        Preconditions.checkNotNull(activityId, "Argument 'activityId' must not be null.");
        Preconditions.checkNotNull(requestType, "Argument 'requestType' must not be null.");
        Preconditions.checkNotNull(startTime, "Argument 'startTime' must not be null.");
        Preconditions.checkNotNull(events, "Argument 'events' must not be null.");
        this.activityId = activityId;
        this.partitionId = partitionId;
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.requestType = requestType;
        this.startTime = startTime;
        this.duration = duration;
        this.events = events;
        this.backendLatency = backendLatency;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public Duration getBackendLatency() {
        return this.backendLatency;
    }

    public Collection<CosmosDiagnosticsRequestEvent> getRequestPipelineEvents() {
        return this.events;
    }
}

