/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava25.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CosmosExcludedRegions {
    private final Set<String> excludedRegions;
    private final String excludedRegionsAsString;
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");

    public CosmosExcludedRegions(Set<String> excludedRegions) {
        Preconditions.checkArgument(excludedRegions != null, "excludedRegions cannot be set to null");
        this.excludedRegions = ImmutableSet.copyOf(excludedRegions);
        this.excludedRegionsAsString = CosmosExcludedRegions.stringifyExcludedRegions(this.excludedRegions);
    }

    public Set<String> getExcludedRegions() {
        return this.excludedRegions;
    }

    public String toString() {
        return this.excludedRegionsAsString;
    }

    private static String stringifyExcludedRegions(Set<String> excludedRegions) {
        String substring = "";
        substring = excludedRegions == null || excludedRegions.isEmpty() ? "" : excludedRegions.stream().map(r -> SPACE_PATTERN.matcher(r.toLowerCase(Locale.ROOT)).replaceAll("")).collect(Collectors.joining(","));
        return "[" + substring + "]";
    }
}

